/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.raw;

import com.exactpro.th2.common.grpc.RawMessage;
import com.exactpro.th2.common.grpc.RawMessageBatch;
import com.exactpro.th2.common.schema.filter.strategy.FilterStrategy;
import com.exactpro.th2.common.schema.filter.strategy.impl.Th2RawMsgFilterStrategy;
import com.exactpro.th2.common.schema.message.FilterFunction;
import com.exactpro.th2.common.schema.message.MessageQueue;
import com.exactpro.th2.common.schema.message.QueueAttribute;
import com.exactpro.th2.common.schema.message.configuration.QueueConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.connection.ConnectionManager;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.raw.RabbitRawBatchQueue;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.router.AbstractRabbitBatchMessageRouter;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.jetbrains.annotations.NotNull;

public class RabbitRawBatchRouter
extends AbstractRabbitBatchMessageRouter<RawMessage, RawMessageBatch, RawMessageBatch.Builder> {
    private static final Set<String> REQUIRED_SUBSCRIBE_ATTRIBUTES = SetUtils.unmodifiableSet((Object[])new String[]{QueueAttribute.RAW.toString(), QueueAttribute.SUBSCRIBE.toString()});
    private static final Set<String> REQUIRED_SEND_ATTRIBUTES = SetUtils.unmodifiableSet((Object[])new String[]{QueueAttribute.RAW.toString(), QueueAttribute.PUBLISH.toString()});

    @Override
    @NotNull
    protected FilterStrategy<Message> getDefaultFilterStrategy() {
        return new Th2RawMsgFilterStrategy();
    }

    @Override
    protected MessageQueue<RawMessageBatch> createQueue(@NotNull ConnectionManager connectionManager, @NotNull QueueConfiguration queueConfiguration, @NotNull FilterFunction filterFunction) {
        RabbitRawBatchQueue queue = new RabbitRawBatchQueue();
        queue.init(connectionManager, queueConfiguration, filterFunction);
        return queue;
    }

    @Override
    protected Set<String> requiredSubscribeAttributes() {
        return REQUIRED_SUBSCRIBE_ATTRIBUTES;
    }

    @Override
    protected Set<String> requiredSendAttributes() {
        return REQUIRED_SEND_ATTRIBUTES;
    }

    @Override
    protected List<RawMessage> getMessages(RawMessageBatch batch) {
        return batch.getMessagesList();
    }

    @Override
    protected RawMessageBatch.Builder createBatchBuilder() {
        return RawMessageBatch.newBuilder();
    }

    @Override
    protected void addMessage(RawMessageBatch.Builder builder, RawMessage message) {
        builder.addMessages(message);
    }

    @Override
    protected RawMessageBatch build(RawMessageBatch.Builder builder) {
        return builder.build();
    }
}

