/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.raw;

import com.exactpro.th2.common.grpc.AnyMessage;
import com.exactpro.th2.common.grpc.MessageGroup;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.grpc.RawMessage;
import com.exactpro.th2.common.grpc.RawMessageBatch;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitSender;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import java.util.stream.Collectors;

public class RabbitRawBatchSender
extends AbstractRabbitSender<RawMessageBatch> {
    private static final Counter OUTGOING_RAW_MSG_BATCH_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_raw_msg_batch_quantity", (String)"Quantity of outgoing raw message batches").register();
    private static final Counter OUTGOING_RAW_MSG_QUANTITY = (Counter)Counter.build((String)"th2_mq_outgoing_raw_msg_quantity", (String)"Quantity of outgoing raw messages").register();

    @Override
    protected Counter getDeliveryCounter() {
        return OUTGOING_RAW_MSG_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return OUTGOING_RAW_MSG_QUANTITY;
    }

    @Override
    protected int extractCountFrom(RawMessageBatch batch) {
        return batch.getMessagesCount();
    }

    @Override
    protected byte[] valueToBytes(RawMessageBatch value) {
        MessageGroupBatch.Builder batchBuilder = MessageGroupBatch.newBuilder();
        for (RawMessage rawMessage : value.getMessagesList()) {
            AnyMessage anyMessage = AnyMessage.newBuilder().setRawMessage(rawMessage).build();
            MessageGroup group = MessageGroup.newBuilder().addMessages(anyMessage).build();
            batchBuilder.addGroups(group);
        }
        return batchBuilder.build().toByteArray();
    }

    @Override
    protected String toShortTraceString(RawMessageBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(RawMessageBatch value) {
        return MessageUtils.getDebugString(this.getClass().getSimpleName(), value.getMessagesList().stream().map(message -> message.getMetadata().getId()).collect(Collectors.toList()));
    }
}

