/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.raw;

import com.exactpro.th2.common.grpc.AnyMessage;
import com.exactpro.th2.common.grpc.MessageGroup;
import com.exactpro.th2.common.grpc.MessageGroupBatch;
import com.exactpro.th2.common.grpc.MessageID;
import com.exactpro.th2.common.grpc.RawMessage;
import com.exactpro.th2.common.grpc.RawMessageBatch;
import com.exactpro.th2.common.grpc.RawMessageMetadata;
import com.exactpro.th2.common.message.MessageUtils;
import com.exactpro.th2.common.metrics.CommonMetrics;
import com.exactpro.th2.common.schema.message.configuration.RouterFilter;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitBatchSubscriber;
import com.google.protobuf.MessageOrBuilder;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RabbitRawBatchSubscriber
extends AbstractRabbitBatchSubscriber<RawMessage, RawMessageBatch> {
    private static final Counter INCOMING_RAW_MSG_BATCH_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_raw_msg_batch_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming raw message batches")).register();
    private static final Counter INCOMING_RAW_MSG_QUANTITY = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("th2_mq_incoming_raw_msg_quantity")).labelNames(new String[]{"session_alias", "direction"})).help("Quantity of incoming raw messages")).register();
    private static final Histogram RAW_MSG_PROCESSING_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(CommonMetrics.DEFAULT_BUCKETS).name("th2_mq_raw_msg_processing_time")).help("Time of processing raw messages")).register();
    private static final String MESSAGE_TYPE = "raw";

    public RabbitRawBatchSubscriber(List<? extends RouterFilter> filters, int messageRecursionLimit) {
        super(filters, messageRecursionLimit);
    }

    @Override
    protected Counter getDeliveryCounter() {
        return INCOMING_RAW_MSG_BATCH_QUANTITY;
    }

    @Override
    protected Counter getContentCounter() {
        return INCOMING_RAW_MSG_QUANTITY;
    }

    @Override
    protected Histogram getProcessingTimer() {
        return RAW_MSG_PROCESSING_TIME;
    }

    @Override
    protected String[] extractLabels(RawMessageBatch batch) {
        MessageID messageID = this.getMessages(batch).get(0).getMetadata().getId();
        return MessageUtils.getSessionAliasAndDirection(messageID);
    }

    @Override
    protected int extractCountFrom(RawMessageBatch batch) {
        return batch.getMessagesCount();
    }

    @Override
    protected List<RawMessageBatch> valueFromBytes(byte[] body) throws Exception {
        MessageGroupBatch groupBatch = this.parseEncodedBatch(body);
        List messageGroups = groupBatch.getGroupsList();
        ArrayList<RawMessageBatch> rawBatches = new ArrayList<RawMessageBatch>(messageGroups.size());
        for (MessageGroup group : messageGroups) {
            RawMessageBatch.Builder builder = RawMessageBatch.newBuilder();
            for (AnyMessage message : group.getMessagesList()) {
                if (message.getKindCase() != AnyMessage.KindCase.RAW_MESSAGE) {
                    throw new IllegalStateException("Message group batch contains parsed messages: " + MessageUtils.toJson((MessageOrBuilder)groupBatch));
                }
                builder.addMessages(message.getRawMessage());
            }
            rawBatches.add(builder.build());
        }
        return rawBatches;
    }

    @Override
    protected List<RawMessage> getMessages(RawMessageBatch batch) {
        return batch.getMessagesList();
    }

    @Override
    protected RawMessageBatch createBatch(List<RawMessage> messages) {
        return RawMessageBatch.newBuilder().addAllMessages(messages).build();
    }

    @Override
    protected String toShortTraceString(RawMessageBatch value) {
        return MessageUtils.toJson((MessageOrBuilder)value);
    }

    @Override
    protected String toShortDebugString(RawMessageBatch value) {
        return MessageUtils.getDebugString(this.getClass().getSimpleName(), value.getMessagesList().stream().map(message -> message.getMetadata().getId()).collect(Collectors.toList()));
    }

    @Override
    protected AbstractRabbitBatchSubscriber.Metadata extractMetadata(RawMessage message) {
        RawMessageMetadata metadata = message.getMetadata();
        MessageID messageID = metadata.getId();
        return new AbstractRabbitBatchSubscriber.Metadata(messageID.getSequence(), MESSAGE_TYPE, messageID.getDirection(), messageID.getConnectionId().getSessionAlias());
    }
}

