/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.message.impl.rabbitmq.router;

import com.exactpro.th2.common.schema.message.configuration.MqRouterFilterConfiguration;
import com.exactpro.th2.common.schema.message.configuration.QueueConfiguration;
import com.exactpro.th2.common.schema.message.impl.rabbitmq.AbstractRabbitMessageRouter;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractRabbitBatchMessageRouter<M extends Message, MB, MBB>
extends AbstractRabbitMessageRouter<MB> {
    @Override
    protected Map<String, MB> findQueueByFilter(Map<String, QueueConfiguration> queues, MB batch) {
        HashMap<String, MBB> result = new HashMap<String, MBB>();
        for (Message message : this.getMessages(batch)) {
            for (String queueAlias : this.filter(queues, message)) {
                result.putIfAbsent(queueAlias, this.createBatchBuilder());
                this.addMessage(result.get(queueAlias), message);
            }
        }
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> this.build(value.getValue())));
    }

    protected Set<String> filter(Map<String, QueueConfiguration> queues, Message message) {
        HashSet<String> aliases = new HashSet<String>();
        for (Map.Entry<String, QueueConfiguration> queueEntry : queues.entrySet()) {
            String queueAlias = queueEntry.getKey();
            List<MqRouterFilterConfiguration> filters = queueEntry.getValue().getFilters();
            if (!filters.isEmpty() && !this.filterMessage(message, filters)) continue;
            aliases.add(queueAlias);
        }
        return aliases;
    }

    protected abstract List<M> getMessages(MB var1);

    protected abstract MBB createBatchBuilder();

    protected abstract void addMessage(MBB var1, M var2);

    protected abstract MB build(MBB var1);
}

