/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.strategy.route;

import com.exactpro.th2.common.schema.strategy.route.RoutingStrategy;
import com.exactpro.th2.common.schema.strategy.route.StrategyName;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingStrategyFactory.class);
    private Map<String, Class<? extends RoutingStrategy>> strategies = new HashMap<String, Class<? extends RoutingStrategy>>();

    public RoutingStrategyFactory() {
        ServiceLoader.load(RoutingStrategy.class).stream().forEach(provider -> {
            Class cls = provider.type();
            StrategyName nameAnnotation = cls.getAnnotation(StrategyName.class);
            String name = nameAnnotation != null && StringUtils.isNotEmpty((CharSequence)nameAnnotation.value()) ? nameAnnotation.value() : cls.getSimpleName();
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                if (constructor.canAccess(null)) {
                    Class prev = this.strategies.put(name, cls);
                    if (prev != null) {
                        throw new IllegalStateException("Strategies names were duplicated with value: '" + name + "'. Classes: '" + cls + "' and '" + prev + "'.");
                    }
                } else {
                    LOGGER.warn("Strategy with name '{}' and class '{}' not added to possible strategy, because class have not access to default constructor", (Object)name, cls);
                }
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Strategy with name '{}' and class '{}' not added to possible strategy, because class have not default constructor", new Object[]{name, cls, e});
            }
        });
    }

    public RoutingStrategy getStrategy(String alias) {
        Class<? extends RoutingStrategy> strategyClass = this.strategies.get(alias);
        if (strategyClass == null) {
            return null;
        }
        try {
            return strategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can not create strategies instance from default constructor", e);
        }
    }
}

