/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.strategy.route.impl;

import com.exactpro.th2.common.schema.filter.strategy.FilterStrategy;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcRawFilterStrategy;
import com.exactpro.th2.common.schema.grpc.configuration.GrpcRouterFilterConfiguration;
import com.exactpro.th2.common.schema.strategy.route.RoutingStrategy;
import com.exactpro.th2.common.schema.strategy.route.StrategyName;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@StrategyName(value="filter")
public class FilterRoutingStrategy
implements RoutingStrategy<GrpcRawFilterStrategy> {
    private GrpcRawFilterStrategy grpcConfiguration;
    private final FilterStrategy<Message> filterStrategy = FilterStrategy.DEFAULT_FILTER_STRATEGY;

    @Override
    public Class<? extends GrpcRawFilterStrategy> getConfigurationClass() {
        return GrpcRawFilterStrategy.class;
    }

    @Override
    public void init(GrpcRawFilterStrategy configuration) {
        this.grpcConfiguration = configuration;
    }

    @Override
    public String getEndpoint(Message message) {
        Set<String> endpoint = this.filter(message);
        if (endpoint.size() != 1) {
            throw new IllegalStateException("Wrong size of endpoints for send. Should be equal to 1");
        }
        return endpoint.iterator().next();
    }

    @Override
    public GrpcRawFilterStrategy getConfiguration() {
        return this.grpcConfiguration;
    }

    @Override
    public String getName() {
        return "filter";
    }

    private Set<String> filter(Message message) {
        HashSet<String> endpoints = new HashSet<String>();
        for (GrpcRouterFilterConfiguration fieldsFilter : this.grpcConfiguration.getFilters()) {
            if ((!fieldsFilter.getMessage().isEmpty() || !fieldsFilter.getMetadata().isEmpty()) && !this.filterStrategy.verify(message, fieldsFilter)) continue;
            endpoints.add(fieldsFilter.getEndpoint());
        }
        return endpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterRoutingStrategy that = (FilterRoutingStrategy)o;
        return Objects.equals(this.grpcConfiguration, that.grpcConfiguration) && Objects.equals(this.filterStrategy, that.filterStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.grpcConfiguration, this.filterStrategy);
    }
}

