/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.strategy.route.impl;

import com.exactpro.th2.common.schema.grpc.configuration.GrpcRawRobinStrategy;
import com.exactpro.th2.common.schema.strategy.route.RoutingStrategy;
import com.exactpro.th2.common.schema.strategy.route.StrategyName;
import com.google.protobuf.Message;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

@StrategyName(value="robin")
public class RobinRoutingStrategy
implements RoutingStrategy<GrpcRawRobinStrategy> {
    private GrpcRawRobinStrategy configuration = new GrpcRawRobinStrategy();
    private final AtomicInteger index = new AtomicInteger(0);

    @Override
    public Class<? extends GrpcRawRobinStrategy> getConfigurationClass() {
        return GrpcRawRobinStrategy.class;
    }

    @Override
    public void init(GrpcRawRobinStrategy configuration) {
        if (configuration != null) {
            this.configuration = configuration;
        }
    }

    @Override
    public String getName() {
        return "robin";
    }

    @Override
    public GrpcRawRobinStrategy getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getEndpoint(Message message) {
        return this.configuration.getEndpoints().get(this.index.getAndUpdate(i -> i + 1 >= this.configuration.getEndpoints().size() ? 0 : i + 1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RobinRoutingStrategy that = (RobinRoutingStrategy)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }
}

