/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.th2.common.schema.strategy.route.json;

import com.exactpro.th2.common.schema.strategy.route.RoutingStrategy;
import com.exactpro.th2.common.schema.strategy.route.RoutingStrategyFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class JsonDeserializerRoutingStategy
extends StdDeserializer<RoutingStrategy> {
    private RoutingStrategyFactory strategyFactory = new RoutingStrategyFactory();
    private ObjectMapper mapper = new ObjectMapper();

    public JsonDeserializerRoutingStategy() {
        super(RoutingStrategy.class);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public RoutingStrategy<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class configurationClass;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (!node.has("name")) {
            throw new RuntimeException("Can not find name for the strategy");
        }
        if (!node.get("name").isTextual()) {
            throw new RuntimeException("Field 'name' is not text in strategy block");
        }
        String strategyName = node.get("name").asText();
        RoutingStrategy strategy = this.strategyFactory.getStrategy(strategyName);
        if (strategy == null) {
            throw new IllegalStateException("Can not find strategy with name: " + strategyName);
        }
        try {
            configurationClass = strategy.getConfigurationClass();
            if (configurationClass == null) {
                throw new RuntimeException("Can not init strategy, because configuration class is null");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get configuration class from strategy", e);
        }
        Object strategyConfiguration = this.mapper.readerFor(configurationClass).readValue(node);
        try {
            strategy.init(strategyConfiguration);
            return strategy;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not init strategy with class: " + strategy.getClass(), e);
        }
    }
}

