/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.exactpro.cradle.cassandra.CassandraStorageSettings;
import com.exactpro.cradle.cassandra.utils.QueryExecutor;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesCreator {
    private static final Logger logger = LoggerFactory.getLogger(TablesCreator.class);
    private final QueryExecutor exec;
    private KeyspaceMetadata keyspaceMetadata;
    private final CassandraStorageSettings settings;

    public TablesCreator(QueryExecutor exec, CassandraStorageSettings settings) {
        this.exec = exec;
        this.settings = settings;
    }

    public void createAll() throws IOException {
        this.createKeyspace();
        this.createInstancesTable();
        this.createMessagesTable();
        this.createProcessedMessagesTable();
        this.createTimeMessagesTable();
        this.createTestEventsTable();
        this.createTimeTestEventsTable();
        this.createRootTestEventsTable();
        this.createTestEventsChildrenTable();
        this.createTestEventsChildrenDatesTable();
        this.createTestEventsMessagesTable();
        this.createMessagesTestEventsTable();
        this.createIntervalsTable();
    }

    public void createKeyspace() throws IOException {
        Optional<KeyspaceMetadata> keyspaceExists = this.getKeyspaceMetadata();
        if (!keyspaceExists.isPresent()) {
            CreateKeyspace createKs = this.settings.getNetworkTopologyStrategy() != null ? (CreateKeyspace)SchemaBuilder.createKeyspace((String)this.settings.getKeyspace()).withNetworkTopologyStrategy(this.settings.getNetworkTopologyStrategy().asMap()) : (CreateKeyspace)SchemaBuilder.createKeyspace((String)this.settings.getKeyspace()).withSimpleStrategy(this.settings.getKeyspaceReplicationFactor());
            this.exec.executeQuery(createKs.asCql(), true);
            logger.info("Keyspace '{}' has been created", (Object)this.settings.getKeyspace());
            this.keyspaceMetadata = this.getKeyspaceMetadata().get();
        } else {
            this.keyspaceMetadata = keyspaceExists.get();
        }
    }

    public void createInstancesTable() throws IOException {
        String tableName = "instances";
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTable create = SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("name", DataTypes.TEXT).withColumn("id", DataTypes.UUID);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createMessagesTable() throws IOException {
        this.createMessagesTable(this.settings.getMessagesTableName());
    }

    public void createProcessedMessagesTable() throws IOException {
        this.createMessagesTable(this.settings.getProcessedMessagesTableName());
    }

    public void createTimeMessagesTable() throws IOException {
        String tableName = this.settings.getTimeMessagesTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("stream_name", DataTypes.TEXT).withPartitionKey("direction", DataTypes.TEXT).withPartitionKey("message_date", DataTypes.DATE).withClusteringColumn("message_time", DataTypes.TIME).withClusteringColumn("message_index", DataTypes.BIGINT).withClusteringOrder("message_time", ClusteringOrder.ASC)).withClusteringOrder("message_index", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createTestEventsTable() throws IOException {
        String tableName = this.settings.getTestEventsTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTable create = SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("id", DataTypes.TEXT).withColumn("name", DataTypes.TEXT).withColumn("type", DataTypes.TEXT).withColumn("root", DataTypes.BOOLEAN).withColumn("parent_id", DataTypes.TEXT).withColumn("event_batch", DataTypes.BOOLEAN).withColumn("stored_date", DataTypes.DATE).withColumn("stored_time", DataTypes.TIME).withColumn("start_date", DataTypes.DATE).withColumn("start_time", DataTypes.TIME).withColumn("end_date", DataTypes.DATE).withColumn("end_time", DataTypes.TIME).withColumn("success", DataTypes.BOOLEAN).withColumn("compressed", DataTypes.BOOLEAN).withColumn("z_content", DataTypes.BLOB).withColumn("event_count", DataTypes.INT);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createTimeTestEventsTable() throws IOException {
        String tableName = this.settings.getTimeTestEventsTableName();
        if (this.isTableExists(tableName)) {
            if (!this.isColumnExists(tableName, "event_batch_metadata")) {
                AlterTableAddColumnEnd alter = SchemaBuilder.alterTable((String)this.settings.getKeyspace(), (String)tableName).addColumn("event_batch_metadata", DataTypes.BLOB);
                this.exec.executeQuery(alter.asCql(), true);
                logger.info("Table '{}' has been altered with column '{}'", (Object)tableName, (Object)"event_batch_metadata");
            }
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("start_date", DataTypes.DATE).withClusteringColumn("start_time", DataTypes.TIME).withClusteringColumn("id", DataTypes.TEXT).withColumn("root", DataTypes.BOOLEAN).withColumn("name", DataTypes.TEXT).withColumn("type", DataTypes.TEXT).withColumn("parent_id", DataTypes.TEXT).withColumn("event_batch", DataTypes.BOOLEAN).withColumn("end_date", DataTypes.DATE).withColumn("end_time", DataTypes.TIME).withColumn("success", DataTypes.BOOLEAN).withColumn("event_count", DataTypes.INT).withColumn("event_batch_metadata", DataTypes.BLOB).withClusteringOrder("start_time", ClusteringOrder.ASC)).withClusteringOrder("id", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createRootTestEventsTable() throws IOException {
        String tableName = this.settings.getRootTestEventsTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("start_date", DataTypes.DATE).withClusteringColumn("start_time", DataTypes.TIME).withClusteringColumn("id", DataTypes.TEXT).withColumn("name", DataTypes.TEXT).withColumn("type", DataTypes.TEXT).withColumn("event_batch", DataTypes.BOOLEAN).withColumn("end_date", DataTypes.DATE).withColumn("end_time", DataTypes.TIME).withColumn("success", DataTypes.BOOLEAN).withColumn("event_count", DataTypes.INT).withClusteringOrder("start_time", ClusteringOrder.ASC)).withClusteringOrder("id", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createTestEventsChildrenTable() throws IOException {
        String tableName = this.settings.getTestEventsChildrenTableName();
        if (this.isTableExists(tableName)) {
            if (!this.isColumnExists(tableName, "event_batch_metadata")) {
                AlterTableAddColumnEnd alter = SchemaBuilder.alterTable((String)this.settings.getKeyspace(), (String)tableName).addColumn("event_batch_metadata", DataTypes.BLOB);
                this.exec.executeQuery(alter.asCql(), true);
                logger.info("Table '{}' has been altered with column '{}'", (Object)tableName, (Object)"event_batch_metadata");
            }
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("parent_id", DataTypes.TEXT).withPartitionKey("start_date", DataTypes.DATE).withClusteringColumn("start_time", DataTypes.TIME).withClusteringColumn("id", DataTypes.TEXT).withColumn("root", DataTypes.BOOLEAN).withColumn("name", DataTypes.TEXT).withColumn("type", DataTypes.TEXT).withColumn("event_batch", DataTypes.BOOLEAN).withColumn("end_date", DataTypes.DATE).withColumn("end_time", DataTypes.TIME).withColumn("success", DataTypes.BOOLEAN).withColumn("event_count", DataTypes.INT).withColumn("event_batch_metadata", DataTypes.BLOB).withClusteringOrder("start_time", ClusteringOrder.ASC)).withClusteringOrder("id", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createTestEventsChildrenDatesTable() throws IOException {
        String tableName = this.settings.getTestEventsChildrenDatesTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("parent_id", DataTypes.TEXT).withClusteringColumn("start_date", DataTypes.DATE).withClusteringOrder("start_date", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createTestEventsMessagesTable() throws IOException {
        String tableName = this.settings.getTestEventsMessagesTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTable create = SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("test_event_id", DataTypes.TEXT).withClusteringColumn("message_ids", (DataType)DataTypes.frozenSetOf((DataType)DataTypes.TEXT));
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    public void createMessagesTestEventsTable() throws IOException {
        String tableName = this.settings.getMessagesTestEventsTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTable create = SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("message_id", DataTypes.TEXT).withClusteringColumn("test_event_id", DataTypes.TEXT).withColumn("batch_id", DataTypes.TEXT);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    protected void createMessagesTable(String name) throws IOException {
        if (this.isTableExists(name)) {
            return;
        }
        CreateTableWithOptions create = (CreateTableWithOptions)((CreateTableWithOptions)SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)name).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("stream_name", DataTypes.TEXT).withClusteringColumn("direction", DataTypes.TEXT).withClusteringColumn("message_index", DataTypes.BIGINT).withColumn("stored_date", DataTypes.DATE).withColumn("stored_time", DataTypes.TIME).withColumn("first_message_date", DataTypes.DATE).withColumn("first_message_time", DataTypes.TIME).withColumn("last_message_date", DataTypes.DATE).withColumn("last_message_time", DataTypes.TIME).withColumn("compressed", DataTypes.BOOLEAN).withColumn("z_content", DataTypes.BLOB).withColumn("message_count", DataTypes.INT).withColumn("last_message_index", DataTypes.BIGINT).withClusteringOrder("direction", ClusteringOrder.ASC)).withClusteringOrder("message_index", ClusteringOrder.ASC);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)name);
    }

    public void createIntervalsTable() throws IOException {
        String tableName = this.settings.getIntervalsTableName();
        if (this.isTableExists(tableName)) {
            return;
        }
        CreateTable create = SchemaBuilder.createTable((String)this.settings.getKeyspace(), (String)tableName).ifNotExists().withPartitionKey("instance_id", DataTypes.UUID).withPartitionKey("interval_start_date", DataTypes.DATE).withClusteringColumn("crawler_name", DataTypes.TEXT).withClusteringColumn("crawler_version", DataTypes.TEXT).withClusteringColumn("crawler_type", DataTypes.TEXT).withClusteringColumn("interval_start_time", DataTypes.TIME).withColumn("interval_end_date", DataTypes.DATE).withColumn("interval_end_time", DataTypes.TIME).withColumn("interval_last_update_date", DataTypes.DATE).withColumn("interval_last_update_time", DataTypes.TIME).withColumn("recovery_state_json", DataTypes.TEXT).withColumn("interval_processed", DataTypes.BOOLEAN);
        this.exec.executeQuery(create.asCql(), true);
        logger.info("Table '{}' has been created", (Object)tableName);
    }

    private boolean isTableExists(String tableName) {
        return this.keyspaceMetadata.getTable(tableName).isPresent();
    }

    private Optional<KeyspaceMetadata> getKeyspaceMetadata() {
        return this.exec.getSession().getMetadata().getKeyspace(this.settings.getKeyspace());
    }

    private boolean isColumnExists(String tableName, String columnName) {
        return ((TableMetadata)this.keyspaceMetadata.getTable(tableName).get()).getColumn("event_batch_metadata").isPresent();
    }
}

