/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao;

import com.exactpro.cradle.cassandra.CassandraStorageSettings;
import com.exactpro.cradle.cassandra.dao.CassandraDataMapper;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalOperator;
import com.exactpro.cradle.cassandra.dao.intervals.converters.IntervalConverter;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchOperator;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventConverter;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventOperator;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageOperator;
import com.exactpro.cradle.cassandra.dao.messages.converters.DetailedMessageBatchConverter;
import com.exactpro.cradle.cassandra.dao.testevents.RootTestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventChildrenDatesOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventChildrenOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventMessagesOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TimeTestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.converters.RootTestEventConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventChildConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventMessagesConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TimeTestEventConverter;

public class CassandraOperators {
    private final MessageBatchOperator messageBatchOperator;
    private final MessageBatchOperator processedMessageBatchOperator;
    private final TimeMessageOperator timeMessageOperator;
    private final TestEventOperator testEventOperator;
    private final RootTestEventOperator rootTestEventOperator;
    private final TestEventChildrenOperator testEventChildrenOperator;
    private final TimeTestEventOperator timeTestEventOperator;
    private final TestEventChildrenDatesOperator testEventChildrenDatesOperator;
    private final TestEventMessagesOperator testEventMessagesOperator;
    private final MessageTestEventOperator messageTestEventOperator;
    private final IntervalOperator intervalOperator;
    private final DetailedMessageBatchConverter messageBatchConverter;
    private final TestEventConverter testEventConverter;
    private final RootTestEventConverter rootTestEventConverter;
    private final TestEventChildConverter testEventChildConverter;
    private final TimeTestEventConverter timeTestEventConverter;
    private final TestEventMessagesConverter testEventMessagesConverter;
    private final MessageTestEventConverter messageTestEventConverter;
    private final IntervalConverter intervalConverter;

    public CassandraOperators(CassandraDataMapper dataMapper, CassandraStorageSettings settings) {
        this.messageBatchOperator = dataMapper.messageBatchOperator(settings.getKeyspace(), settings.getMessagesTableName());
        this.processedMessageBatchOperator = dataMapper.messageBatchOperator(settings.getKeyspace(), settings.getProcessedMessagesTableName());
        this.timeMessageOperator = dataMapper.timeMessageOperator(settings.getKeyspace(), settings.getTimeMessagesTableName());
        this.testEventOperator = dataMapper.testEventOperator(settings.getKeyspace(), settings.getTestEventsTableName());
        this.timeTestEventOperator = dataMapper.timeTestEventOperator(settings.getKeyspace(), settings.getTimeTestEventsTableName());
        this.rootTestEventOperator = dataMapper.rootTestEventOperator(settings.getKeyspace(), settings.getRootTestEventsTableName());
        this.testEventChildrenOperator = dataMapper.testEventChildrenOperator(settings.getKeyspace(), settings.getTestEventsChildrenTableName());
        this.testEventChildrenDatesOperator = dataMapper.testEventChildrenDatesOperator(settings.getKeyspace(), settings.getTestEventsChildrenDatesTableName());
        this.testEventMessagesOperator = dataMapper.testEventMessagesOperator(settings.getKeyspace(), settings.getTestEventsMessagesTableName());
        this.messageTestEventOperator = dataMapper.messageTestEventOperator(settings.getKeyspace(), settings.getMessagesTestEventsTableName());
        this.intervalOperator = dataMapper.intervalOperator(settings.getKeyspace(), settings.getIntervalsTableName());
        this.messageBatchConverter = dataMapper.detailedMessageBatchConverter();
        this.testEventConverter = dataMapper.testEventConverter();
        this.rootTestEventConverter = dataMapper.rootTestEventConverter();
        this.testEventChildConverter = dataMapper.testEventChildConverter();
        this.timeTestEventConverter = dataMapper.timeTestEventConverter();
        this.testEventMessagesConverter = dataMapper.testEventMessagesConverter();
        this.messageTestEventConverter = dataMapper.messageTestEventConverter();
        this.intervalConverter = dataMapper.intervalConverter();
    }

    public MessageBatchOperator getMessageBatchOperator() {
        return this.messageBatchOperator;
    }

    public MessageBatchOperator getProcessedMessageBatchOperator() {
        return this.processedMessageBatchOperator;
    }

    public TimeMessageOperator getTimeMessageOperator() {
        return this.timeMessageOperator;
    }

    public TestEventOperator getTestEventOperator() {
        return this.testEventOperator;
    }

    public RootTestEventOperator getRootTestEventOperator() {
        return this.rootTestEventOperator;
    }

    public TestEventChildrenOperator getTestEventChildrenOperator() {
        return this.testEventChildrenOperator;
    }

    public TimeTestEventOperator getTimeTestEventOperator() {
        return this.timeTestEventOperator;
    }

    public TestEventChildrenDatesOperator getTestEventChildrenDatesOperator() {
        return this.testEventChildrenDatesOperator;
    }

    public TestEventMessagesOperator getTestEventMessagesOperator() {
        return this.testEventMessagesOperator;
    }

    public MessageTestEventOperator getMessageTestEventOperator() {
        return this.messageTestEventOperator;
    }

    public IntervalOperator getIntervalOperator() {
        return this.intervalOperator;
    }

    public DetailedMessageBatchConverter getMessageBatchConverter() {
        return this.messageBatchConverter;
    }

    public TestEventConverter getTestEventConverter() {
        return this.testEventConverter;
    }

    public RootTestEventConverter getRootTestEventConverter() {
        return this.rootTestEventConverter;
    }

    public TestEventChildConverter getTestEventChildConverter() {
        return this.testEventChildConverter;
    }

    public TimeTestEventConverter getTimeTestEventConverter() {
        return this.timeTestEventConverter;
    }

    public TestEventMessagesConverter getTestEventMessagesConverter() {
        return this.testEventMessagesConverter;
    }

    public MessageTestEventConverter getMessageTestEventConverter() {
        return this.messageTestEventConverter;
    }

    public IntervalConverter getIntervalConverter() {
        return this.intervalConverter;
    }
}

