/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.intervals;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.cassandra.CassandraSemaphore;
import com.exactpro.cradle.cassandra.dao.AsyncOperator;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalEntity;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalOperator;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalSupplies;
import com.exactpro.cradle.cassandra.dao.intervals.converters.IntervalConverter;
import com.exactpro.cradle.cassandra.iterators.IntervalsIteratorAdapter;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.intervals.Interval;
import com.exactpro.cradle.intervals.IntervalsWorker;
import com.exactpro.cradle.utils.CradleStorageException;
import com.exactpro.cradle.utils.UpdateNotAppliedException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class CassandraIntervalsWorker
implements IntervalsWorker {
    private final CassandraSemaphore semaphore;
    private final UUID instanceUuid;
    private final Function<BoundStatementBuilder, BoundStatementBuilder> writeAttrs;
    private final Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs;
    private final IntervalOperator intervalOperator;
    private final IntervalConverter converter;
    private final PagingSupplies pagingSupplies;

    public CassandraIntervalsWorker(CassandraSemaphore semaphore, UUID instanceUuid, Function<BoundStatementBuilder, BoundStatementBuilder> writeAttrs, Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs, IntervalSupplies supplies) {
        this.semaphore = semaphore;
        this.instanceUuid = instanceUuid;
        this.writeAttrs = writeAttrs;
        this.readAttrs = readAttrs;
        this.intervalOperator = supplies.getOperator();
        this.converter = supplies.getConverter();
        this.pagingSupplies = supplies.getpagingSupplies();
    }

    public boolean storeInterval(Interval interval) throws IOException {
        try {
            return this.storeIntervalAsync(interval).get();
        }
        catch (Exception e) {
            throw new IOException("Error while storing interval from: " + interval.getStartTime() + ", to: " + interval.getEndTime() + ", name: " + interval.getCrawlerName() + ", version: " + interval.getCrawlerVersion() + ", type: " + interval.getCrawlerType(), e);
        }
    }

    public CompletableFuture<Boolean> storeIntervalAsync(Interval interval) {
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> {
            IntervalEntity intervalEntity = new IntervalEntity(interval, this.instanceUuid);
            return this.intervalOperator.writeInterval(intervalEntity, this.writeAttrs);
        });
        return future.thenApply(AsyncResultSet::wasApplied);
    }

    public Iterable<Interval> getIntervalsPerDay(Instant from, Instant to, String crawlerName, String crawlerVersion, String crawlerType) throws IOException {
        try {
            return this.getIntervalsPerDayAsync(from, to, crawlerName, crawlerVersion, crawlerType).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting intervals from: " + from + ", to: " + to + " by Crawler with name: " + crawlerName + ", version: " + crawlerVersion + ", type: " + crawlerType, e);
        }
    }

    public CompletableFuture<Iterable<Interval>> getIntervalsPerDayAsync(Instant from, Instant to, String crawlerName, String crawlerVersion, String crawlerType) throws CradleStorageException {
        LocalDateTime fromDateTime = LocalDateTime.ofInstant(from, CassandraCradleStorage.TIMEZONE_OFFSET);
        LocalDateTime toDateTime = LocalDateTime.ofInstant(to, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.checkTimeBoundaries(fromDateTime, toDateTime, from, to);
        LocalTime fromTime = fromDateTime.toLocalTime();
        LocalTime toTime = toDateTime.toLocalTime();
        LocalDate date = fromDateTime.toLocalDate();
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.intervalOperator.getIntervals(this.instanceUuid, date, fromTime, toTime, crawlerName, crawlerVersion, crawlerType, this.readAttrs));
        String queryInfo = "get intervals from: " + from + ", to: " + to + " by Crawler with name: " + crawlerName + ", version: " + crawlerVersion + ", type: " + crawlerType;
        return future.thenApply(result -> new IntervalsIteratorAdapter((MappedAsyncPagingIterable<IntervalEntity>)result, this.pagingSupplies, this.converter, queryInfo));
    }

    private Iterable<Interval> getIntervalsPerDay(LocalDateTime from, LocalDateTime to, String crawlerName, String crawlerVersion, String crawlerType) throws IOException {
        try {
            return this.getIntervalsPerDayAsync(from, to, crawlerName, crawlerVersion, crawlerType).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting intervals from: " + from + ", to: " + to + " by Crawler with name: " + crawlerName + ", version: " + crawlerVersion + ", type: " + crawlerType, e);
        }
    }

    private CompletableFuture<Iterable<Interval>> getIntervalsPerDayAsync(LocalDateTime from, LocalDateTime to, String crawlerName, String crawlerVersion, String crawlerType) throws CradleStorageException {
        this.checkTimeBoundaries(from, to);
        LocalTime fromTime = from.toLocalTime();
        LocalTime toTime = to.toLocalTime();
        LocalDate date = from.toLocalDate();
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.intervalOperator.getIntervals(this.instanceUuid, date, fromTime, toTime, crawlerName, crawlerVersion, crawlerType, this.readAttrs));
        String queryInfo = "get intervals from: " + from + ", to: " + to + " by Crawler with name: " + crawlerName + ", version: " + crawlerVersion + ", type: " + crawlerType;
        return future.thenApply(result -> new IntervalsIteratorAdapter((MappedAsyncPagingIterable<IntervalEntity>)result, this.pagingSupplies, this.converter, queryInfo));
    }

    public Iterable<Interval> getIntervals(Instant from, Instant to, String crawlerName, String crawlerVersion, String crawlerType) throws IOException {
        LocalDateTime fromDateTime = LocalDateTime.ofInstant(from, CassandraCradleStorage.TIMEZONE_OFFSET);
        LocalDateTime toDateTime = LocalDateTime.ofInstant(to, CassandraCradleStorage.TIMEZONE_OFFSET);
        Iterable<Object> result = new ArrayList<Interval>();
        if (fromDateTime.toLocalDate().compareTo(toDateTime.toLocalDate()) == 0) {
            return this.getIntervalsPerDay(from, to, crawlerName, crawlerVersion, crawlerType);
        }
        LocalDateTime point = fromDateTime;
        while (point.isBefore(toDateTime)) {
            point = LocalDateTime.of(fromDateTime.toLocalDate(), LocalTime.MAX);
            if (point.isAfter(toDateTime)) {
                point = toDateTime;
            }
            Iterable<Interval> intervals = this.getIntervalsPerDay(fromDateTime, point, crawlerName, crawlerVersion, crawlerType);
            fromDateTime = fromDateTime.plusDays(1L).truncatedTo(ChronoUnit.DAYS);
            result = Iterables.concat(result, intervals);
        }
        return result;
    }

    public Interval setIntervalLastUpdateTimeAndDate(Interval interval, Instant newLastUpdateTime) throws IOException {
        try {
            return this.setIntervalLastUpdateTimeAndDateAsync(interval, newLastUpdateTime).get();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof UpdateNotAppliedException) {
                throw (UpdateNotAppliedException)e.getCause();
            }
            throw new IOException("Error while occupying interval from: " + interval.getStartTime() + ", to: " + interval.getEndTime() + ", name: " + interval.getCrawlerName() + ", version: " + interval.getCrawlerVersion() + ", type: " + interval.getCrawlerType(), e);
        }
    }

    public CompletableFuture<Interval> setIntervalLastUpdateTimeAndDateAsync(Interval interval, Instant newLastUpdateTime) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(newLastUpdateTime, CassandraCradleStorage.TIMEZONE_OFFSET);
        LocalTime time = dateTime.toLocalTime();
        LocalDate date = dateTime.toLocalDate();
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.intervalOperator.setIntervalLastUpdateTimeAndDate(this.instanceUuid, LocalDate.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalTime.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), time, date, LocalTime.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalDate.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), interval.getCrawlerName(), interval.getCrawlerVersion(), interval.getCrawlerType(), this.writeAttrs));
        return future.thenApply(result -> {
            if (!result.wasApplied()) {
                throw new UpdateNotAppliedException(String.format("Cannot update the 'lastUpdateTime' column for interval from %s to %s (name: %s, version: %s)", interval.getStartTime(), interval.getEndTime(), interval.getCrawlerName(), interval.getCrawlerVersion()));
            }
            return Interval.copyWith((Interval)interval, (String)interval.getRecoveryState(), (LocalDateTime)dateTime, (boolean)interval.isProcessed());
        });
    }

    public Interval updateRecoveryState(Interval interval, String recoveryState) throws IOException {
        try {
            return this.updateRecoveryStateAsync(interval, recoveryState).get();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof UpdateNotAppliedException) {
                throw (UpdateNotAppliedException)e.getCause();
            }
            throw new IOException("Error while updating recovery state of interval from: " + interval.getStartTime() + ", to: " + interval.getEndTime() + ", name: " + interval.getCrawlerName() + ", version: " + interval.getCrawlerVersion() + ", type: " + interval.getCrawlerType(), e);
        }
    }

    public CompletableFuture<Interval> updateRecoveryStateAsync(Interval interval, String recoveryState) {
        LocalDateTime newLastUpdateDateTime = LocalDateTime.ofInstant(Instant.now(), CassandraCradleStorage.TIMEZONE_OFFSET);
        LocalTime newLastUpdateTime = newLastUpdateDateTime.toLocalTime();
        LocalDate newLastUpdateDate = newLastUpdateDateTime.toLocalDate();
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.intervalOperator.updateRecoveryState(this.instanceUuid, LocalDate.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalTime.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), newLastUpdateTime, newLastUpdateDate, recoveryState, interval.getRecoveryState(), LocalTime.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalDate.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), interval.getCrawlerName(), interval.getCrawlerVersion(), interval.getCrawlerType(), this.writeAttrs));
        return future.thenApply(result -> {
            if (!result.wasApplied()) {
                throw new UpdateNotAppliedException(String.format("Cannot update the 'recovery state' column for interval from %s to %s (name: %s, version: %s)", interval.getStartTime(), interval.getEndTime(), interval.getCrawlerName(), interval.getCrawlerVersion()));
            }
            return Interval.copyWith((Interval)interval, (String)recoveryState, (LocalDateTime)newLastUpdateDateTime, (boolean)interval.isProcessed());
        });
    }

    public Interval setIntervalProcessed(Interval interval, boolean processed) throws IOException {
        try {
            return this.setIntervalProcessedAsync(interval, processed).get();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof UpdateNotAppliedException) {
                throw (UpdateNotAppliedException)e.getCause();
            }
            throw new IOException("Error while setting processed flag of interval from: " + interval.getStartTime() + ", to: " + interval.getEndTime() + ", name: " + interval.getCrawlerName() + ", version: " + interval.getCrawlerVersion() + ", type: " + interval.getCrawlerType(), e);
        }
    }

    public CompletableFuture<Interval> setIntervalProcessedAsync(Interval interval, boolean processed) {
        LocalDateTime newLastUpdateDateTime = LocalDateTime.ofInstant(Instant.now(), CassandraCradleStorage.TIMEZONE_OFFSET);
        LocalTime newLastUpdateTime = newLastUpdateDateTime.toLocalTime();
        LocalDate newLastUpdateDate = newLastUpdateDateTime.toLocalDate();
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.intervalOperator.setIntervalProcessed(this.instanceUuid, LocalDate.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalTime.from(interval.getStartTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), newLastUpdateTime, newLastUpdateDate, processed, interval.isProcessed(), LocalTime.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), LocalDate.from(interval.getLastUpdateDateTime().atOffset(CassandraCradleStorage.TIMEZONE_OFFSET)), interval.getCrawlerName(), interval.getCrawlerVersion(), interval.getCrawlerType(), this.writeAttrs));
        return future.thenApply(result -> {
            if (!result.wasApplied()) {
                throw new UpdateNotAppliedException(String.format("Cannot update the 'process' column for interval from %s to %s (name: %s, version: %s)", interval.getStartTime(), interval.getEndTime(), interval.getCrawlerName(), interval.getCrawlerVersion()));
            }
            return Interval.copyWith((Interval)interval, (String)interval.getRecoveryState(), (LocalDateTime)newLastUpdateDateTime, (boolean)processed);
        });
    }

    private void checkTimeBoundaries(LocalDateTime fromDateTime, LocalDateTime toDateTime, Instant originalFrom, Instant originalTo) throws CradleStorageException {
        LocalDate toDate;
        LocalDate fromDate = fromDateTime.toLocalDate();
        if (!fromDate.equals(toDate = toDateTime.toLocalDate())) {
            throw new CradleStorageException("Left and right boundaries should be of the same date, but got '" + originalFrom + "' and '" + originalTo + "'");
        }
    }

    private void checkTimeBoundaries(LocalDateTime fromDateTime, LocalDateTime toDateTime) throws CradleStorageException {
        LocalDate toDate;
        LocalDate fromDate = fromDateTime.toLocalDate();
        if (!fromDate.equals(toDate = toDateTime.toLocalDate())) {
            throw new CradleStorageException("Left and right boundaries should be of the same date, but got '" + fromDateTime + "' and '" + toDateTime + "'");
        }
    }
}

