/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.intervals;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.exactpro.cradle.intervals.Interval;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class IntervalEntity {
    private static final Logger logger = LoggerFactory.getLogger(IntervalEntity.class);
    public static final ZoneOffset TIMEZONE_OFFSET = ZoneOffset.UTC;
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="interval_start_date")
    private LocalDate startDate;
    @ClusteringColumn(value=0)
    @CqlName(value="crawler_name")
    private String crawlerName;
    @ClusteringColumn(value=1)
    @CqlName(value="crawler_version")
    private String crawlerVersion;
    @ClusteringColumn(value=2)
    @CqlName(value="crawler_type")
    private String crawlerType;
    @ClusteringColumn(value=3)
    @CqlName(value="interval_start_time")
    private LocalTime startTime;
    @CqlName(value="interval_end_date")
    private LocalDate endDate;
    @CqlName(value="interval_end_time")
    private LocalTime endTime;
    @CqlName(value="interval_last_update_date")
    private LocalDate lastUpdateDate;
    @CqlName(value="interval_last_update_time")
    private LocalTime lastUpdateTime;
    @CqlName(value="recovery_state_json")
    private String recoveryStateJson;
    @CqlName(value="interval_processed")
    private boolean processed;

    public IntervalEntity() {
    }

    public IntervalEntity(Interval interval, UUID instanceId) {
        this.startTime = LocalTime.from(interval.getStartTime().atOffset(TIMEZONE_OFFSET));
        this.endTime = LocalTime.from(interval.getEndTime().atOffset(TIMEZONE_OFFSET));
        this.startDate = LocalDate.from(interval.getStartTime().atOffset(TIMEZONE_OFFSET));
        this.endDate = LocalDate.from(interval.getEndTime().atOffset(TIMEZONE_OFFSET));
        this.lastUpdateTime = LocalTime.from(interval.getLastUpdateDateTime().atOffset(TIMEZONE_OFFSET));
        this.lastUpdateDate = LocalDate.from(interval.getLastUpdateDateTime().atOffset(TIMEZONE_OFFSET));
        this.recoveryStateJson = interval.getRecoveryState();
        this.instanceId = instanceId;
        this.crawlerName = interval.getCrawlerName();
        this.crawlerVersion = interval.getCrawlerVersion();
        this.crawlerType = interval.getCrawlerType();
        this.processed = interval.isProcessed();
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public LocalDate getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(LocalDate lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(LocalTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getRecoveryStateJson() {
        return this.recoveryStateJson;
    }

    public void setRecoveryStateJson(String recoveryStateJson) {
        this.recoveryStateJson = recoveryStateJson;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public void setCrawlerName(String crawlerName) {
        this.crawlerName = crawlerName;
    }

    public String getCrawlerVersion() {
        return this.crawlerVersion;
    }

    public void setCrawlerVersion(String crawlerVersion) {
        this.crawlerVersion = crawlerVersion;
    }

    public String getCrawlerType() {
        return this.crawlerType;
    }

    public void setCrawlerType(String crawlerType) {
        this.crawlerType = crawlerType;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Interval asInterval() throws IOException {
        return Interval.builder().startTime(Instant.from(LocalDateTime.of(this.startDate, this.startTime).atOffset(TIMEZONE_OFFSET))).endTime(Instant.from(LocalDateTime.of(this.endDate, this.endTime).atOffset(TIMEZONE_OFFSET))).recoveryState(this.recoveryStateJson).lastUpdateTime(Instant.from(LocalDateTime.of(this.lastUpdateDate, this.lastUpdateTime).atOffset(TIMEZONE_OFFSET))).crawlerName(this.crawlerName).crawlerVersion(this.crawlerVersion).crawlerType(this.crawlerType).processed(this.processed).build();
    }
}

