/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchEntity;
import com.exactpro.cradle.messages.MessageToStoreBuilder;
import com.exactpro.cradle.messages.StoredMessage;
import com.exactpro.cradle.messages.StoredMessageBatch;
import com.exactpro.cradle.messages.StoredMessageMetadata;
import com.exactpro.cradle.utils.CradleStorageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class DetailedMessageBatchEntity
extends MessageBatchEntity {
    private static final Logger logger = LoggerFactory.getLogger(DetailedMessageBatchEntity.class);
    @CqlName(value="stored_date")
    private LocalDate storedDate;
    @CqlName(value="stored_time")
    private LocalTime storedTime;
    @CqlName(value="first_message_date")
    private LocalDate firstMessageDate;
    @CqlName(value="first_message_time")
    private LocalTime firstMessageTime;
    @CqlName(value="last_message_date")
    private LocalDate lastMessageDate;
    @CqlName(value="last_message_time")
    private LocalTime lastMessageTime;
    @CqlName(value="message_count")
    private int messageCount;
    @CqlName(value="last_message_index")
    private long lastMessageIndex;

    public DetailedMessageBatchEntity() {
    }

    public DetailedMessageBatchEntity(StoredMessageBatch batch, UUID instanceId) throws IOException {
        super(batch, instanceId);
        logger.trace("Adding details to Entity");
        this.setStoredTimestamp(Instant.now());
        this.setFirstMessageTimestamp(batch.getFirstTimestamp());
        this.setLastMessageTimestamp(batch.getLastTimestamp());
        this.setMessageCount(batch.getMessageCount());
        this.setLastMessageIndex(batch.getLastMessage().getIndex());
    }

    public StoredMessageBatch toStoredMessageBatch(StoredMessageBatch messageBatch) throws IOException, CradleStorageException {
        for (StoredMessage storedMessage : this.toStoredMessages()) {
            MessageToStoreBuilder builder = new MessageToStoreBuilder().content(storedMessage.getContent()).direction(storedMessage.getDirection()).streamName(storedMessage.getStreamName()).timestamp(storedMessage.getTimestamp()).index(storedMessage.getIndex());
            StoredMessageMetadata metadata = storedMessage.getMetadata();
            if (metadata != null) {
                metadata.toMap().forEach((arg_0, arg_1) -> ((MessageToStoreBuilder)builder).metadata(arg_0, arg_1));
            }
            messageBatch.addMessage(builder.build());
        }
        return messageBatch;
    }

    public LocalDate getStoredDate() {
        return this.storedDate;
    }

    public void setStoredDate(LocalDate storedDate) {
        this.storedDate = storedDate;
    }

    public LocalTime getStoredTime() {
        return this.storedTime;
    }

    public void setStoredTime(LocalTime storedTime) {
        this.storedTime = storedTime;
    }

    @Transient
    public Instant getStoredTimestamp() {
        return LocalDateTime.of(this.getStoredDate(), this.getStoredTime()).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStoredTimestamp(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStoredDate(ldt.toLocalDate());
        this.setStoredTime(ldt.toLocalTime());
    }

    public LocalDate getFirstMessageDate() {
        return this.firstMessageDate;
    }

    public void setFirstMessageDate(LocalDate firstMessageDate) {
        this.firstMessageDate = firstMessageDate;
    }

    public LocalTime getFirstMessageTime() {
        return this.firstMessageTime;
    }

    public void setFirstMessageTime(LocalTime firstMessageTime) {
        this.firstMessageTime = firstMessageTime;
    }

    @Transient
    public Instant getFirstMessageTimestamp() {
        return LocalDateTime.of(this.getFirstMessageDate(), this.getFirstMessageTime()).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setFirstMessageTimestamp(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setFirstMessageDate(ldt.toLocalDate());
        this.setFirstMessageTime(ldt.toLocalTime());
    }

    public LocalDate getLastMessageDate() {
        return this.lastMessageDate;
    }

    public void setLastMessageDate(LocalDate lastMessageDate) {
        this.lastMessageDate = lastMessageDate;
    }

    public LocalTime getLastMessageTime() {
        return this.lastMessageTime;
    }

    public void setLastMessageTime(LocalTime lastMessageTime) {
        this.lastMessageTime = lastMessageTime;
    }

    @Transient
    public Instant getLastMessageTimestamp() {
        return LocalDateTime.of(this.getLastMessageDate(), this.getLastMessageTime()).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setLastMessageTimestamp(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setLastMessageDate(ldt.toLocalDate());
        this.setLastMessageTime(ldt.toLocalTime());
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public long getLastMessageIndex() {
        return this.lastMessageIndex;
    }

    public void setLastMessageIndex(long lastMessageIndex) {
        this.lastMessageIndex = lastMessageIndex;
    }
}

