/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.datastax.oss.driver.api.mapper.annotations.QueryProvider;
import com.datastax.oss.driver.api.mapper.annotations.Select;
import com.exactpro.cradle.cassandra.dao.messages.DetailedMessageBatchEntity;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchQueryProvider;
import com.exactpro.cradle.cassandra.dao.messages.StreamEntity;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageOperator;
import com.exactpro.cradle.messages.StoredMessageFilter;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Dao
public interface MessageBatchOperator {
    @Select
    public PagingIterable<DetailedMessageBatchEntity> get(UUID var1, String var2, Function<BoundStatementBuilder, BoundStatementBuilder> var3);

    @Select
    public PagingIterable<DetailedMessageBatchEntity> get(UUID var1, String var2, String var3, Function<BoundStatementBuilder, BoundStatementBuilder> var4);

    @Select
    public DetailedMessageBatchEntity get(UUID var1, String var2, String var3, long var4, Function<BoundStatementBuilder, BoundStatementBuilder> var6);

    @Query(value="SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction AND message_index>=:fromIndex AND message_index<=:toIndex")
    public CompletableFuture<MappedAsyncPagingIterable<DetailedMessageBatchEntity>> getMessageBatches(UUID var1, String var2, String var3, long var4, long var6, Function<BoundStatementBuilder, BoundStatementBuilder> var8);

    @Query(value="SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction AND message_index<=:toIndex ORDER BY direction DESC, message_index DESC")
    public PagingIterable<DetailedMessageBatchEntity> getMessageBatchesReversed(UUID var1, String var2, String var3, long var4, Function<BoundStatementBuilder, BoundStatementBuilder> var6);

    @Query(value="SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction AND message_index<=:messageIndex ORDER BY direction DESC, message_index DESC LIMIT 1")
    public CompletableFuture<DetailedMessageBatchEntity> getMessageBatch(UUID var1, String var2, String var3, long var4, Function<BoundStatementBuilder, BoundStatementBuilder> var6);

    @Select
    public PagingIterable<DetailedMessageBatchEntity> getAll(Function<BoundStatementBuilder, BoundStatementBuilder> var1);

    @Query(value="SELECT message_index FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction LIMIT 1")
    public CompletableFuture<Row> getFirstIndex(UUID var1, String var2, String var3, Function<BoundStatementBuilder, BoundStatementBuilder> var4);

    @Query(value="SELECT last_message_index FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction ORDER BY direction DESC, message_index DESC LIMIT 1")
    public CompletableFuture<Row> getLastIndex(UUID var1, String var2, String var3, Function<BoundStatementBuilder, BoundStatementBuilder> var4);

    @QueryProvider(providerClass=MessageBatchQueryProvider.class, entityHelpers={DetailedMessageBatchEntity.class})
    public CompletableFuture<MappedAsyncPagingIterable<DetailedMessageBatchEntity>> filterMessages(UUID var1, StoredMessageFilter var2, MessageBatchOperator var3, TimeMessageOperator var4, Function<BoundStatementBuilder, BoundStatementBuilder> var5);

    @Query(value="SELECT DISTINCT instance_id, stream_name from ${qualifiedTableId}")
    public PagingIterable<StreamEntity> getStreams(Function<BoundStatementBuilder, BoundStatementBuilder> var1);

    @Insert
    public CompletableFuture<DetailedMessageBatchEntity> writeMessageBatch(DetailedMessageBatchEntity var1, Function<BoundStatementBuilder, BoundStatementBuilder> var2);
}

