/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.DaoBase;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventEntity;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventEntityHelper__MapperGenerated;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventOperator;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTestEventOperatorImpl__MapperGenerated
extends DaoBase
implements MessageTestEventOperator {
    private static final Logger LOG = LoggerFactory.getLogger(MessageTestEventOperatorImpl__MapperGenerated.class);
    private final MessageTestEventEntityHelper__MapperGenerated messageTestEventEntityHelper;
    private final PreparedStatement getTestEventsStatement;
    private final PreparedStatement writeTestEventStatement;

    private MessageTestEventOperatorImpl__MapperGenerated(MapperContext context, MessageTestEventEntityHelper__MapperGenerated messageTestEventEntityHelper, PreparedStatement getTestEventsStatement, PreparedStatement writeTestEventStatement) {
        super(context);
        this.messageTestEventEntityHelper = messageTestEventEntityHelper;
        this.getTestEventsStatement = getTestEventsStatement;
        this.writeTestEventStatement = writeTestEventStatement;
    }

    @Override
    public CompletableFuture<MappedAsyncPagingIterable<MessageTestEventEntity>> getTestEvents(UUID instanceId, String messageId, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.getTestEventsStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (messageId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("messageId", (Object)messageId, String.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToEntityIterable((Statement)boundStatement, (EntityHelper)this.messageTestEventEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MessageTestEventEntity> writeTestEvent(MessageTestEventEntity messageEvent, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.writeTestEventStatement.boundStatementBuilder(new Object[0]);
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            this.messageTestEventEntityHelper.set(messageEvent, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToSingleEntity((Statement)boundStatement, (EntityHelper)this.messageTestEventEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static CompletableFuture<MessageTestEventOperator> initAsync(MapperContext context) {
        LOG.debug("[{}] Initializing new instance for keyspace = {} and table = {}", new Object[]{context.getSession().getName(), context.getKeyspaceId(), context.getTableId()});
        MessageTestEventOperatorImpl__MapperGenerated.throwIfProtocolVersionV3((MapperContext)context);
        try {
            MessageTestEventEntityHelper__MapperGenerated messageTestEventEntityHelper = new MessageTestEventEntityHelper__MapperGenerated(context);
            if (((Boolean)context.getCustomState().get("datastax.mapper.schemaValidationEnabled")).booleanValue()) {
                messageTestEventEntityHelper.validateEntityFields();
            }
            ArrayList<CompletionStage> prepareStages = new ArrayList<CompletionStage>();
            SimpleStatement getTestEventsStatement_simple = MessageTestEventOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND message_id=:messageId", (MapperContext)context, (EntityHelper)messageTestEventEntityHelper);
            LOG.debug("[{}] Preparing query `{}` for method getTestEvents(java.util.UUID,java.lang.String,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)getTestEventsStatement_simple.getQuery());
            CompletionStage getTestEventsStatement = MessageTestEventOperatorImpl__MapperGenerated.prepare((SimpleStatement)getTestEventsStatement_simple, (MapperContext)context);
            prepareStages.add(getTestEventsStatement);
            SimpleStatement writeTestEventStatement_simple = messageTestEventEntityHelper.insert().build();
            LOG.debug("[{}] Preparing query `{}` for method writeTestEvent(com.exactpro.cradle.cassandra.dao.messages.MessageTestEventEntity,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)writeTestEventStatement_simple.getQuery());
            CompletionStage writeTestEventStatement = MessageTestEventOperatorImpl__MapperGenerated.prepare((SimpleStatement)writeTestEventStatement_simple, (MapperContext)context);
            prepareStages.add(writeTestEventStatement);
            return CompletableFutures.allSuccessful(prepareStages).thenApply(v -> new MessageTestEventOperatorImpl__MapperGenerated(context, messageTestEventEntityHelper, (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)getTestEventsStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)writeTestEventStatement))).toCompletableFuture();
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static MessageTestEventOperator init(MapperContext context) {
        BlockingOperation.checkNotDriverThread();
        return (MessageTestEventOperator)CompletableFutures.getUninterruptibly(MessageTestEventOperatorImpl__MapperGenerated.initAsync(context));
    }
}

