/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.Direction;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.messages.StoredMessage;
import com.exactpro.cradle.messages.StoredMessageId;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TimeMessageEntity {
    private static final Logger logger = LoggerFactory.getLogger(TimeMessageEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="stream_name")
    private String streamName;
    @PartitionKey(value=2)
    @CqlName(value="direction")
    private String direction;
    @PartitionKey(value=3)
    @CqlName(value="message_date")
    private LocalDate messageDate;
    @ClusteringColumn(value=0)
    @CqlName(value="message_time")
    private LocalTime messageTime;
    @ClusteringColumn(value=1)
    @CqlName(value="message_index")
    private long messageIndex;

    public TimeMessageEntity() {
    }

    public TimeMessageEntity(StoredMessage message, UUID instanceId) {
        logger.trace("Creating time-message data from message");
        this.setInstanceId(instanceId);
        this.setMessageTimestamp(message.getTimestamp());
        StoredMessageId id = message.getId();
        this.setStreamName(id.getStreamName());
        this.setDirection(id.getDirection().getLabel());
        this.setMessageIndex(id.getIndex());
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public LocalDate getMessageDate() {
        return this.messageDate;
    }

    public void setMessageDate(LocalDate messageDate) {
        this.messageDate = messageDate;
    }

    public LocalTime getMessageTime() {
        return this.messageTime;
    }

    public void setMessageTime(LocalTime messageTime) {
        this.messageTime = messageTime;
    }

    @Transient
    public Instant getMessageTimestamp() {
        return LocalDateTime.of(this.getMessageDate(), this.getMessageTime()).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setMessageTimestamp(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setMessageDate(ldt.toLocalDate());
        this.setMessageTime(ldt.toLocalTime());
    }

    public long getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(long messageIndex) {
        this.messageIndex = messageIndex;
    }

    public StoredMessageId createMessageId() {
        return new StoredMessageId(this.getStreamName(), Direction.byLabel((String)this.getDirection()), this.getMessageIndex());
    }
}

