/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.exactpro.cradle.cassandra.dao.testevents.RootTestEventDateEntity;
import com.exactpro.cradle.cassandra.dao.testevents.RootTestEventEntity;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Dao
public interface RootTestEventOperator {
    @Query(value="SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND start_date=:startDate AND start_time>=:timeFrom AND start_time<=:timeTo")
    public CompletableFuture<MappedAsyncPagingIterable<RootTestEventEntity>> getTestEventsDirect(UUID var1, LocalDate var2, LocalTime var3, LocalTime var4, Function<BoundStatementBuilder, BoundStatementBuilder> var5);

    @Query(value="SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND start_date=:startDate AND start_time>=:timeFrom AND start_time<=:timeTo ORDER BY start_time DESC, id DESC")
    public CompletableFuture<MappedAsyncPagingIterable<RootTestEventEntity>> getTestEventsReverse(UUID var1, LocalDate var2, LocalTime var3, LocalTime var4, Function<BoundStatementBuilder, BoundStatementBuilder> var5);

    @Insert
    public CompletableFuture<RootTestEventEntity> writeTestEvent(RootTestEventEntity var1, Function<BoundStatementBuilder, BoundStatementBuilder> var2);

    @Query(value="UPDATE ${qualifiedTableId} SET success=:success WHERE instance_id=:instanceId AND start_date=:startDate AND start_time=:startTime AND id=:eventId")
    public CompletableFuture<AsyncResultSet> updateStatus(UUID var1, LocalDate var2, LocalTime var3, String var4, boolean var5, Function<BoundStatementBuilder, BoundStatementBuilder> var6);

    @Query(value="SELECT DISTINCT instance_id, start_date from ${qualifiedTableId}")
    public PagingIterable<RootTestEventDateEntity> getDates(Function<BoundStatementBuilder, BoundStatementBuilder> var1);
}

