/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.SettableByName;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.internal.mapper.entity.EntityHelperBase;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultUpdate;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventChildEntity;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEventChildEntityHelper__MapperGenerated
extends EntityHelperBase<TestEventChildEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(TestEventChildEntityHelper__MapperGenerated.class);
    private static final GenericType<Boolean> GENERIC_TYPE = new GenericType<Boolean>(){};
    private static final GenericType<LocalTime> GENERIC_TYPE1 = new GenericType<LocalTime>(){};
    private static final GenericType<String> GENERIC_TYPE2 = new GenericType<String>(){};
    private static final GenericType<UUID> GENERIC_TYPE3 = new GenericType<UUID>(){};
    private static final GenericType<LocalDate> GENERIC_TYPE4 = new GenericType<LocalDate>(){};
    private static final GenericType<Integer> GENERIC_TYPE5 = new GenericType<Integer>(){};
    private static final GenericType<ByteBuffer> GENERIC_TYPE6 = new GenericType<ByteBuffer>(){};
    private final List<String> primaryKeys;

    public TestEventChildEntityHelper__MapperGenerated(MapperContext context) {
        super(context, "test_event_child_entity");
        LOG.debug("[{}] Entity TestEventChildEntity will be mapped to {}{}", new Object[]{context.getSession().getName(), this.getKeyspaceId() == null ? "" : this.getKeyspaceId() + ".", this.getTableId()});
        this.primaryKeys = ImmutableList.builder().add((Object)"instance_id").add((Object)"parent_id").add((Object)"start_date").add((Object)"start_time").add((Object)"id").build();
    }

    public Class<TestEventChildEntity> getEntityClass() {
        return TestEventChildEntity.class;
    }

    public <SettableT extends SettableByName<SettableT>> SettableT set(TestEventChildEntity entity, SettableT target, NullSavingStrategy nullSavingStrategy) {
        if (entity.getInstanceId() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("instance_id", (Object)entity.getInstanceId(), UUID.class);
        }
        if (entity.getParentId() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("parent_id", (Object)entity.getParentId(), String.class);
        }
        if (entity.getStartDate() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("start_date", (Object)entity.getStartDate(), LocalDate.class);
        }
        if (entity.getStartTime() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("start_time", (Object)entity.getStartTime(), LocalTime.class);
        }
        if (entity.getId() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("id", (Object)entity.getId(), String.class);
        }
        target = target.setBoolean("root", entity.isRoot());
        if (entity.getEventBatchMetadata() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("event_batch_metadata", (Object)entity.getEventBatchMetadata(), ByteBuffer.class);
        }
        if (entity.getName() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("name", (Object)entity.getName(), String.class);
        }
        if (entity.getType() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("type", (Object)entity.getType(), String.class);
        }
        target = target.setBoolean("event_batch", entity.isEventBatch());
        if (entity.getEndDate() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("end_date", (Object)entity.getEndDate(), LocalDate.class);
        }
        if (entity.getEndTime() != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
            target = target.set("end_time", (Object)entity.getEndTime(), LocalTime.class);
        }
        target = target.setBoolean("success", entity.isSuccess());
        target = target.setInt("event_count", entity.getEventCount());
        return target;
    }

    public TestEventChildEntity get(GettableByName source) {
        TestEventChildEntity returnValue = new TestEventChildEntity();
        returnValue.setInstanceId((UUID)source.get("instance_id", UUID.class));
        returnValue.setParentId((String)source.get("parent_id", String.class));
        returnValue.setStartDate((LocalDate)source.get("start_date", LocalDate.class));
        returnValue.setStartTime((LocalTime)source.get("start_time", LocalTime.class));
        returnValue.setId((String)source.get("id", String.class));
        returnValue.setRoot(source.getBoolean("root"));
        returnValue.setEventBatchMetadata((ByteBuffer)source.get("event_batch_metadata", ByteBuffer.class));
        returnValue.setName((String)source.get("name", String.class));
        returnValue.setType((String)source.get("type", String.class));
        returnValue.setEventBatch(source.getBoolean("event_batch"));
        returnValue.setEndDate((LocalDate)source.get("end_date", LocalDate.class));
        returnValue.setEndTime((LocalTime)source.get("end_time", LocalTime.class));
        returnValue.setSuccess(source.getBoolean("success"));
        returnValue.setEventCount(source.getInt("event_count"));
        return returnValue;
    }

    public RegularInsert insert() {
        this.throwIfKeyspaceMissing();
        InsertInto insertInto = this.keyspaceId == null ? QueryBuilder.insertInto((CqlIdentifier)this.tableId) : QueryBuilder.insertInto((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        return insertInto.value("instance_id", (Term)QueryBuilder.bindMarker((String)"instance_id")).value("parent_id", (Term)QueryBuilder.bindMarker((String)"parent_id")).value("start_date", (Term)QueryBuilder.bindMarker((String)"start_date")).value("start_time", (Term)QueryBuilder.bindMarker((String)"start_time")).value("id", (Term)QueryBuilder.bindMarker((String)"id")).value("root", (Term)QueryBuilder.bindMarker((String)"root")).value("event_batch_metadata", (Term)QueryBuilder.bindMarker((String)"event_batch_metadata")).value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("type", (Term)QueryBuilder.bindMarker((String)"type")).value("event_batch", (Term)QueryBuilder.bindMarker((String)"event_batch")).value("end_date", (Term)QueryBuilder.bindMarker((String)"end_date")).value("end_time", (Term)QueryBuilder.bindMarker((String)"end_time")).value("success", (Term)QueryBuilder.bindMarker((String)"success")).value("event_count", (Term)QueryBuilder.bindMarker((String)"event_count"));
    }

    public Select selectByPrimaryKeyParts(int parameterCount) {
        Select select = this.selectStart();
        for (int i = 0; i < parameterCount && i < this.primaryKeys.size(); ++i) {
            String columnName = this.primaryKeys.get(i);
            select = (Select)select.whereColumn(columnName).isEqualTo((Term)QueryBuilder.bindMarker((String)columnName));
        }
        return select;
    }

    public Select selectByPrimaryKey() {
        return this.selectByPrimaryKeyParts(this.primaryKeys.size());
    }

    public Select selectStart() {
        this.throwIfKeyspaceMissing();
        SelectFrom selectFrom = this.keyspaceId == null ? QueryBuilder.selectFrom((CqlIdentifier)this.tableId) : QueryBuilder.selectFrom((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        return selectFrom.column("instance_id").column("parent_id").column("start_date").column("start_time").column("id").column("root").column("event_batch_metadata").column("name").column("type").column("event_batch").column("end_date").column("end_time").column("success").column("event_count");
    }

    public DeleteSelection deleteStart() {
        this.throwIfKeyspaceMissing();
        return this.keyspaceId == null ? QueryBuilder.deleteFrom((CqlIdentifier)this.tableId) : QueryBuilder.deleteFrom((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
    }

    public Delete deleteByPrimaryKeyParts(int parameterCount) {
        if (parameterCount <= 0) {
            throw new MapperException("parameterCount must be greater than 0");
        }
        DeleteSelection deleteSelection = this.deleteStart();
        String columnName = this.primaryKeys.get(0);
        Delete delete = (Delete)deleteSelection.whereColumn(columnName).isEqualTo((Term)QueryBuilder.bindMarker((String)columnName));
        for (int i = 1; i < parameterCount && i < this.primaryKeys.size(); ++i) {
            columnName = this.primaryKeys.get(i);
            delete = (Delete)delete.whereColumn(columnName).isEqualTo((Term)QueryBuilder.bindMarker((String)columnName));
        }
        return delete;
    }

    public Delete deleteByPrimaryKey() {
        return this.deleteByPrimaryKeyParts(this.primaryKeys.size());
    }

    public DefaultUpdate updateStart() {
        this.throwIfKeyspaceMissing();
        UpdateStart update = this.keyspaceId == null ? QueryBuilder.update((CqlIdentifier)this.tableId) : QueryBuilder.update((CqlIdentifier)this.keyspaceId, (CqlIdentifier)this.tableId);
        return (DefaultUpdate)update.setColumn("root", (Term)QueryBuilder.bindMarker((String)"root")).setColumn("event_batch_metadata", (Term)QueryBuilder.bindMarker((String)"event_batch_metadata")).setColumn("name", (Term)QueryBuilder.bindMarker((String)"name")).setColumn("type", (Term)QueryBuilder.bindMarker((String)"type")).setColumn("event_batch", (Term)QueryBuilder.bindMarker((String)"event_batch")).setColumn("end_date", (Term)QueryBuilder.bindMarker((String)"end_date")).setColumn("end_time", (Term)QueryBuilder.bindMarker((String)"end_time")).setColumn("success", (Term)QueryBuilder.bindMarker((String)"success")).setColumn("event_count", (Term)QueryBuilder.bindMarker((String)"event_count"));
    }

    public DefaultUpdate updateByPrimaryKey() {
        return (DefaultUpdate)((Update)((Update)((Update)this.updateStart().where((Relation)Relation.column((String)"instance_id").isEqualTo((Term)QueryBuilder.bindMarker((String)"instance_id"))).where((Relation)Relation.column((String)"parent_id").isEqualTo((Term)QueryBuilder.bindMarker((String)"parent_id")))).where((Relation)Relation.column((String)"start_date").isEqualTo((Term)QueryBuilder.bindMarker((String)"start_date")))).where((Relation)Relation.column((String)"start_time").isEqualTo((Term)QueryBuilder.bindMarker((String)"start_time")))).where((Relation)Relation.column((String)"id").isEqualTo((Term)QueryBuilder.bindMarker((String)"id")));
    }

    public void validateEntityFields() {
        CqlIdentifier keyspaceId = this.keyspaceId != null ? this.keyspaceId : (CqlIdentifier)this.context.getSession().getKeyspace().orElse(null);
        String entityClassName = "com.exactpro.cradle.cassandra.dao.testevents.TestEventChildEntity";
        if (keyspaceId == null) {
            LOG.warn("[{}] Unable to validate table: {} for the entity class: {} because the keyspace is unknown (the entity does not declare a default keyspace, and neither the session nor the DAO were created with a keyspace). The DAO will only work if it uses fully-qualified queries with @Query or @QueryProvider.", new Object[]{this.context.getSession().getName(), this.tableId, entityClassName});
            return;
        }
        if (!this.keyspaceNamePresent(this.context.getSession().getMetadata().getKeyspaces(), keyspaceId)) {
            LOG.warn("[{}] Unable to validate table: {} for the entity class: {} because the session metadata has no information about the keyspace: {}.", new Object[]{this.context.getSession().getName(), this.tableId, entityClassName, keyspaceId});
            return;
        }
        Optional keyspace = this.context.getSession().getMetadata().getKeyspace(keyspaceId);
        ArrayList<CqlIdentifier> expectedCqlNames = new ArrayList<CqlIdentifier>();
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"instance_id"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"parent_id"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"start_date"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"start_time"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"id"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"root"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"event_batch_metadata"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"name"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"type"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"event_batch"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"end_date"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"end_time"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"success"));
        expectedCqlNames.add(CqlIdentifier.fromCql((String)"event_count"));
        Optional tableMetadata = keyspace.flatMap(v -> v.getTable(this.tableId));
        Optional userDefinedType = keyspace.flatMap(v -> v.getUserDefinedType(this.tableId));
        if (tableMetadata.isPresent()) {
            ArrayList<CqlIdentifier> expectedCqlClusteringColumns = new ArrayList<CqlIdentifier>();
            expectedCqlClusteringColumns.add(CqlIdentifier.fromCql((String)"start_time"));
            expectedCqlClusteringColumns.add(CqlIdentifier.fromCql((String)"id"));
            List missingTableClusteringColumnNames = this.findMissingColumns(expectedCqlClusteringColumns, ((TableMetadata)tableMetadata.get()).getClusteringColumns().keySet());
            if (!missingTableClusteringColumnNames.isEmpty()) {
                throw new IllegalArgumentException(String.format("The CQL ks.table: %s.%s has missing Clustering columns: %s that are defined in the entity class: %s", keyspaceId, this.tableId, missingTableClusteringColumnNames, entityClassName));
            }
            ArrayList<CqlIdentifier> expectedCqlPKs = new ArrayList<CqlIdentifier>();
            expectedCqlPKs.add(CqlIdentifier.fromCql((String)"instance_id"));
            expectedCqlPKs.add(CqlIdentifier.fromCql((String)"parent_id"));
            expectedCqlPKs.add(CqlIdentifier.fromCql((String)"start_date"));
            List missingTablePksNames = this.findMissingColumns(expectedCqlPKs, ((TableMetadata)tableMetadata.get()).getPartitionKey());
            if (!missingTablePksNames.isEmpty()) {
                throw new IllegalArgumentException(String.format("The CQL ks.table: %s.%s has missing Primary Key columns: %s that are defined in the entity class: %s", keyspaceId, this.tableId, missingTablePksNames, entityClassName));
            }
            List missingTableCqlNames = this.findMissingCqlIdentifiers(expectedCqlNames, ((TableMetadata)tableMetadata.get()).getColumns().keySet());
            if (!missingTableCqlNames.isEmpty()) {
                throw new IllegalArgumentException(String.format("The CQL ks.table: %s.%s has missing columns: %s that are defined in the entity class: %s", keyspaceId, this.tableId, missingTableCqlNames, entityClassName));
            }
            LinkedHashMap<CqlIdentifier, Object> expectedTypesPerColumn = new LinkedHashMap<CqlIdentifier, Object>();
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"root"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"start_time"), GENERIC_TYPE1);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"type"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_batch"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"success"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"instance_id"), GENERIC_TYPE3);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"end_time"), GENERIC_TYPE1);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"end_date"), GENERIC_TYPE4);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"id"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"name"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"start_date"), GENERIC_TYPE4);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_count"), GENERIC_TYPE5);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"parent_id"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_batch_metadata"), GENERIC_TYPE6);
            List missingTableTypes = TestEventChildEntityHelper__MapperGenerated.findTypeMismatches(expectedTypesPerColumn, (Map)((TableMetadata)tableMetadata.get()).getColumns(), (CodecRegistry)this.context.getSession().getContext().getCodecRegistry());
            this.throwMissingTableTypesIfNotEmpty(missingTableTypes, keyspaceId, this.tableId, entityClassName);
        } else if (userDefinedType.isPresent()) {
            List columns = ((UserDefinedType)userDefinedType.get()).getFieldNames();
            List missingTableCqlNames = this.findMissingCqlIdentifiers(expectedCqlNames, columns);
            if (!missingTableCqlNames.isEmpty()) {
                throw new IllegalArgumentException(String.format("The CQL ks.udt: %s.%s has missing columns: %s that are defined in the entity class: %s", keyspaceId, this.tableId, missingTableCqlNames, entityClassName));
            }
            LinkedHashMap<CqlIdentifier, Object> expectedTypesPerColumn = new LinkedHashMap<CqlIdentifier, Object>();
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"root"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"start_time"), GENERIC_TYPE1);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"type"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_batch"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"success"), GENERIC_TYPE);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"instance_id"), GENERIC_TYPE3);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"end_time"), GENERIC_TYPE1);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"end_date"), GENERIC_TYPE4);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"id"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"name"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"start_date"), GENERIC_TYPE4);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_count"), GENERIC_TYPE5);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"parent_id"), GENERIC_TYPE2);
            expectedTypesPerColumn.put(CqlIdentifier.fromCql((String)"event_batch_metadata"), GENERIC_TYPE6);
            List expectedColumns = ((UserDefinedType)userDefinedType.get()).getFieldNames();
            List expectedTypes = ((UserDefinedType)userDefinedType.get()).getFieldTypes();
            List missingTableTypes = TestEventChildEntityHelper__MapperGenerated.findTypeMismatches(expectedTypesPerColumn, (List)expectedColumns, (List)expectedTypes, (CodecRegistry)this.context.getSession().getContext().getCodecRegistry());
            this.throwMissingUdtTypesIfNotEmpty(missingTableTypes, keyspaceId, this.tableId, entityClassName);
        } else {
            LOG.warn("[{}] There is no ks.table or UDT: {}.{} for the entity class: {}, or metadata is out of date.", new Object[]{this.context.getSession().getName(), keyspaceId, this.tableId, entityClassName});
        }
    }
}

