/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventSingle;
import com.exactpro.cradle.testevents.StoredTestEventWithContent;
import com.exactpro.cradle.testevents.StoredTestEventWrapper;
import com.exactpro.cradle.testevents.TestEventBatchToStoreBuilder;
import com.exactpro.cradle.testevents.TestEventToStoreBuilder;
import com.exactpro.cradle.utils.CompressionUtils;
import com.exactpro.cradle.utils.CradleStorageException;
import com.exactpro.cradle.utils.TestEventUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TestEventEntity {
    private static final Logger logger = LoggerFactory.getLogger(TestEventEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="id")
    private String id;
    @CqlName(value="name")
    private String name;
    @CqlName(value="type")
    private String type;
    @CqlName(value="root")
    private boolean root;
    @CqlName(value="parent_id")
    private String parentId;
    @CqlName(value="event_batch")
    private boolean eventBatch;
    @CqlName(value="start_date")
    private LocalDate startDate;
    @CqlName(value="start_time")
    private LocalTime startTime;
    @CqlName(value="end_date")
    private LocalDate endDate;
    @CqlName(value="end_time")
    private LocalTime endTime;
    @CqlName(value="success")
    private boolean success;
    @CqlName(value="compressed")
    private boolean compressed;
    @CqlName(value="z_content")
    private ByteBuffer content;

    public TestEventEntity() {
    }

    public TestEventEntity(StoredTestEvent event, UUID instanceId) throws IOException {
        byte[] content;
        logger.debug("Creating Entity from test event");
        StoredTestEventId parentId = event.getParentId();
        this.setInstanceId(instanceId);
        this.setId(event.getId().toString());
        this.setName(event.getName());
        this.setType(event.getType());
        this.setRoot(parentId == null);
        this.setParentId(parentId != null ? parentId.toString() : null);
        if (event instanceof StoredTestEventBatch) {
            content = TestEventUtils.serializeTestEvents((Collection)((StoredTestEventBatch)event).getTestEvents());
            this.setEventBatch(true);
        } else {
            content = ((StoredTestEventSingle)event).getContent();
            this.setEventBatch(false);
        }
        this.setStartTimestamp(event.getStartTimestamp());
        this.setEndTimestamp(event.getEndTimestamp());
        this.setSuccess(event.isSuccess());
        boolean toCompress = this.isNeedToCompress(content);
        if (toCompress) {
            try {
                logger.trace("Compressing content of test event", (Object)event.getId());
                content = CompressionUtils.compressData((byte[])content);
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not compress test event contents (ID: '%s') to save in Cradle", event.getId().toString()), e);
            }
        }
        this.setCompressed(toCompress);
        this.setContent(ByteBuffer.wrap(content));
    }

    protected boolean isNeedToCompress(byte[] contentBytes) {
        return contentBytes.length > 5000;
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isEventBatch() {
        return this.eventBatch;
    }

    public void setEventBatch(boolean eventBatch) {
        this.eventBatch = eventBatch;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Transient
    public Instant getStartTimestamp() {
        LocalDate sd = this.getStartDate();
        LocalTime st = this.getStartTime();
        if (sd == null || st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStartTimestamp(Instant timestamp) {
        if (timestamp == null) {
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStartDate(ldt.toLocalDate());
        this.setStartTime(ldt.toLocalTime());
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Transient
    public Instant getEndTimestamp() {
        LocalDate ed = this.getEndDate();
        LocalTime et = this.getEndTime();
        if (ed == null || et == null) {
            return null;
        }
        return LocalDateTime.of(ed, et).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setEndTimestamp(Instant timestamp) {
        if (timestamp == null) {
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setEndDate(ldt.toLocalDate());
        this.setEndTime(ldt.toLocalTime());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public void setContent(ByteBuffer content) {
        this.content = content;
    }

    public StoredTestEventSingle toStoredTestEventSingle() throws IOException, CradleStorageException {
        if (this.isEventBatch()) {
            return null;
        }
        StoredTestEventId eventId = new StoredTestEventId(this.id);
        byte[] eventContent = TestEventUtils.getTestEventContentBytes((ByteBuffer)this.content, (boolean)this.compressed, (StoredTestEventId)eventId);
        return new StoredTestEventSingle((StoredTestEventWithContent)new TestEventToStoreBuilder().id(eventId).name(this.name).type(this.type).parentId(this.parentId != null ? new StoredTestEventId(this.parentId) : null).startTimestamp(this.getStartTimestamp()).endTimestamp(this.getEndTimestamp()).success(this.success).content(eventContent).build());
    }

    public StoredTestEventBatch toStoredTestEventBatch() throws IOException, CradleStorageException {
        if (!this.isEventBatch()) {
            return null;
        }
        StoredTestEventId eventId = new StoredTestEventId(this.id);
        StoredTestEventBatch result = new StoredTestEventBatch(new TestEventBatchToStoreBuilder().id(eventId).name(this.name).type(this.type).parentId(this.parentId != null ? new StoredTestEventId(this.parentId) : null).build());
        try {
            TestEventUtils.bytesToTestEvents((ByteBuffer)this.content, (boolean)this.compressed, (StoredTestEventBatch)result);
        }
        catch (CradleStorageException e) {
            throw new IOException("Error while adding deserialized test events to batch", e);
        }
        return result;
    }

    public StoredTestEvent toStoredTestEvent() throws IOException, CradleStorageException {
        return this.isEventBatch() ? this.toStoredTestEventBatch() : this.toStoredTestEventSingle();
    }

    public StoredTestEventWrapper toStoredTestEventWrapper() throws IOException, CradleStorageException {
        return new StoredTestEventWrapper(this.toStoredTestEvent());
    }
}

