/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.exactpro.cradle.messages.StoredMessageId;
import com.exactpro.cradle.testevents.StoredTestEventId;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TestEventMessagesEntity {
    private static final Logger logger = LoggerFactory.getLogger(TestEventMessagesEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="test_event_id")
    private String eventId;
    @ClusteringColumn(value=0)
    @CqlName(value="message_ids")
    private Set<String> messageIds;

    public TestEventMessagesEntity() {
    }

    public TestEventMessagesEntity(StoredTestEventId eventId, Set<StoredMessageId> messageIds, UUID instanceId) throws IOException {
        logger.debug("Creating entity with event-messages link");
        this.eventId = eventId.toString();
        this.messageIds = messageIds.stream().map(id -> id.toString()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        this.instanceId = instanceId;
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String testEventId) {
        this.eventId = testEventId;
    }

    public Set<String> getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(Set<String> messageIds) {
        this.messageIds = messageIds;
    }
}

