/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventMetadata;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestEventMetadataEntity {
    private static final Logger logger = LoggerFactory.getLogger(TestEventMetadataEntity.class);
    @CqlName(value="name")
    private String name;
    @CqlName(value="type")
    private String type;
    @CqlName(value="event_batch")
    private boolean eventBatch;
    @CqlName(value="end_date")
    private LocalDate endDate;
    @CqlName(value="end_time")
    private LocalTime endTime;
    @CqlName(value="success")
    private boolean success;
    @CqlName(value="event_count")
    private int eventCount;

    public TestEventMetadataEntity() {
    }

    public TestEventMetadataEntity(StoredTestEvent event, UUID instanceId) {
        logger.trace("Creating metadata from event");
        this.setInstanceId(instanceId);
        this.setStartTimestamp(event.getStartTimestamp());
        this.setId(event.getId().toString());
        this.setName(event.getName());
        this.setType(event.getType());
        this.setEndTimestamp(event.getEndTimestamp());
        this.setSuccess(event.isSuccess());
        if (event instanceof StoredTestEventBatch) {
            this.setEventBatch(true);
            this.setEventCount(((StoredTestEventBatch)event).getTestEventsCount());
        } else {
            this.setEventBatch(false);
            this.setEventCount(1);
        }
    }

    public abstract UUID getInstanceId();

    public abstract void setInstanceId(UUID var1);

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract LocalDate getStartDate();

    public abstract void setStartDate(LocalDate var1);

    public abstract LocalTime getStartTime();

    public abstract void setStartTime(LocalTime var1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEventBatch() {
        return this.eventBatch;
    }

    public void setEventBatch(boolean eventBatch) {
        this.eventBatch = eventBatch;
    }

    @Transient
    public Instant getStartTimestamp() {
        LocalDate sd = this.getStartDate();
        LocalTime st = this.getStartTime();
        if (sd == null || st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStartTimestamp(Instant timestamp) {
        if (timestamp == null) {
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStartDate(ldt.toLocalDate());
        this.setStartTime(ldt.toLocalTime());
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    @Transient
    public Instant getEndTimestamp() {
        LocalDate ed = this.getEndDate();
        LocalTime et = this.getEndTime();
        if (ed == null || et == null) {
            return null;
        }
        return LocalDateTime.of(ed, et).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setEndTimestamp(Instant timestamp) {
        if (timestamp == null) {
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setEndDate(ldt.toLocalDate());
        this.setEndTime(ldt.toLocalTime());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public StoredTestEventMetadata toStoredTestEventMetadata() throws IOException {
        StoredTestEventMetadata result = new StoredTestEventMetadata();
        result.setId(new StoredTestEventId(this.getId()));
        result.setName(this.name);
        result.setType(this.type);
        result.setStartTimestamp(this.getStartTimestamp());
        result.setEndTimestamp(this.getEndTimestamp());
        result.setSuccess(this.success);
        result.setBatch(this.eventBatch);
        result.setEventCount(this.eventCount);
        return result;
    }
}

