/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventMetadataEntity;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventMetadata;
import com.exactpro.cradle.utils.TestEventUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;

public abstract class TestEventWithParentMetadataEntity
extends TestEventMetadataEntity {
    @CqlName(value="event_batch_metadata")
    private ByteBuffer eventBatchMetadata;

    public TestEventWithParentMetadataEntity() {
    }

    public TestEventWithParentMetadataEntity(StoredTestEvent event, UUID instanceId) throws IOException {
        super(event, instanceId);
        StoredTestEventId parentId = event.getParentId();
        this.setRoot(parentId == null);
        this.setParentId(parentId != null ? parentId.toString() : null);
        if (event instanceof StoredTestEventBatch) {
            StoredTestEventBatch batch = (StoredTestEventBatch)event;
            byte[] metadata = TestEventUtils.serializeTestEventsMetadata((Collection)batch.getTestEventsMetadata().getTestEvents());
            this.setEventBatchMetadata(ByteBuffer.wrap(metadata));
        } else {
            this.eventBatchMetadata = null;
        }
    }

    public abstract boolean isRoot();

    public abstract void setRoot(boolean var1);

    public abstract String getParentId();

    public abstract void setParentId(String var1);

    public ByteBuffer getEventBatchMetadata() {
        return this.eventBatchMetadata;
    }

    public void setEventBatchMetadata(ByteBuffer eventBatchMetadata) {
        this.eventBatchMetadata = eventBatchMetadata;
    }

    @Override
    public StoredTestEventMetadata toStoredTestEventMetadata() throws IOException {
        StoredTestEventMetadata result = super.toStoredTestEventMetadata();
        String parentId = this.getParentId();
        if (parentId != null) {
            result.setParentId(new StoredTestEventId(parentId));
        }
        if (this.eventBatchMetadata == null) {
            return result;
        }
        result.setBatchMetadataBytes(this.eventBatchMetadata.array());
        return result;
    }
}

