/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.iterators;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.exactpro.cradle.cassandra.dao.EntityConverter;
import com.exactpro.cradle.cassandra.iterators.PagedIterator;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConvertingPagedIterator<R, E>
implements Iterator<R> {
    private static final Logger logger = LoggerFactory.getLogger(ConvertingPagedIterator.class);
    private final PagedIterator<E> it;

    public ConvertingPagedIterator(MappedAsyncPagingIterable<E> rows, PagingSupplies pagingSupplies, EntityConverter<E> converter, String queryInfo) {
        this.it = new PagedIterator<E>(rows, pagingSupplies, converter, queryInfo);
    }

    protected abstract R convertEntity(E var1) throws IOException;

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public R next() {
        E entity = this.it.next();
        logger.trace("Converting entity");
        try {
            return this.convertEntity(entity);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while getting next data row", e);
        }
    }
}

