/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.iterators;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.AsyncPagingIterableWrapper;
import com.exactpro.cradle.cassandra.dao.EntityConverter;
import com.exactpro.cradle.cassandra.retries.CannotRetryException;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.cassandra.retries.RetryUtils;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedIterator<E>
implements Iterator<E> {
    private final Logger logger = LoggerFactory.getLogger(PagedIterator.class);
    private MappedAsyncPagingIterable<E> rows;
    private Iterator<E> rowsIterator;
    private final PagingSupplies pagingSupplies;
    private final Function<Row, E> mapper;
    private final String queryInfo;

    public PagedIterator(MappedAsyncPagingIterable<E> rows, PagingSupplies pagingSupplies, EntityConverter<E> converter, String queryInfo) {
        this.rows = rows;
        this.rowsIterator = rows.currentPage().iterator();
        this.pagingSupplies = pagingSupplies;
        this.mapper = row -> converter.convert((Row)row);
        this.queryInfo = queryInfo;
    }

    @Override
    public boolean hasNext() {
        if (!this.rowsIterator.hasNext()) {
            try {
                this.rowsIterator = this.fetchNextIterator();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while getting next page of result", e);
            }
            if (this.rowsIterator == null || !this.rowsIterator.hasNext()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E next() {
        this.logger.trace("Getting next data row for '{}'", (Object)this.queryInfo);
        return this.rowsIterator.next();
    }

    private Iterator<E> fetchNextIterator() throws IllegalStateException, InterruptedException, ExecutionException, CannotRetryException {
        if (this.rows.hasMorePages()) {
            this.logger.debug("Getting next result page for '{}'", (Object)this.queryInfo);
            this.rows = this.fetchNextPage(this.rows);
            return this.rows.currentPage().iterator();
        }
        return null;
    }

    private MappedAsyncPagingIterable<E> fetchNextPage(MappedAsyncPagingIterable<E> rows) throws CannotRetryException, IllegalStateException, InterruptedException, ExecutionException {
        if (this.pagingSupplies == null) {
            this.logger.debug("Fetching next result page for '{}' with default behavior", (Object)this.queryInfo);
            return (MappedAsyncPagingIterable)rows.fetchNextPage().toCompletableFuture().get();
        }
        ExecutionInfo ei = rows.getExecutionInfo();
        ByteBuffer newState = ei.getPagingState();
        Statement<?> stmt = ei.getStatement().copy(newState);
        stmt = RetryUtils.applyPolicyVerdict(stmt, this.pagingSupplies.getExecPolicy().onNextPage(stmt, this.queryInfo));
        CqlSession session = this.pagingSupplies.getSession();
        int retryCount = 0;
        while (true) {
            try {
                return (MappedAsyncPagingIterable)session.executeAsync(stmt).thenApply(next -> new AsyncPagingIterableWrapper((AsyncPagingIterable)next, this.mapper)).toCompletableFuture().get();
            }
            catch (Exception e) {
                stmt = ei.getStatement().copy(newState).setPageSize(stmt.getPageSize()).setConsistencyLevel(stmt.getConsistencyLevel());
                stmt = RetryUtils.applyPolicyVerdict(stmt, this.pagingSupplies.getExecPolicy().onError(stmt, this.queryInfo, (Throwable)e, retryCount));
                this.logger.debug("Retrying next page request ({}) for '{}' with page size {} and CL {} after error: '{}'", new Object[]{++retryCount, this.queryInfo, stmt.getPageSize(), stmt.getConsistencyLevel(), e.getMessage()});
                continue;
            }
            break;
        }
    }
}

