/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.iterators;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.exactpro.cradle.CradleObjectsFactory;
import com.exactpro.cradle.cassandra.dao.messages.DetailedMessageBatchEntity;
import com.exactpro.cradle.cassandra.dao.messages.converters.DetailedMessageBatchConverter;
import com.exactpro.cradle.cassandra.iterators.ConvertingPagedIterator;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.messages.StoredMessageBatch;
import com.exactpro.cradle.utils.CradleStorageException;
import java.io.IOException;

public class StoredMessageBatchIterator
extends ConvertingPagedIterator<StoredMessageBatch, DetailedMessageBatchEntity> {
    private final CradleObjectsFactory objectsFactory;
    private final int limit;
    private long returnedEntities;

    public StoredMessageBatchIterator(MappedAsyncPagingIterable<DetailedMessageBatchEntity> rows, PagingSupplies pagingSupplies, DetailedMessageBatchConverter converter, String queryInfo, CradleObjectsFactory objectsFactory, int limit) {
        super(rows, pagingSupplies, converter, queryInfo);
        this.objectsFactory = objectsFactory;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        if (this.limit > 0 && this.returnedEntities >= (long)this.limit) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public StoredMessageBatch next() {
        ++this.returnedEntities;
        return (StoredMessageBatch)super.next();
    }

    @Override
    protected StoredMessageBatch convertEntity(DetailedMessageBatchEntity entity) throws IOException {
        try {
            return entity.toStoredMessageBatch(this.objectsFactory.createMessageBatch());
        }
        catch (CradleStorageException e) {
            throw new IOException("Error occurred while converting entity to StoredMessageBatch", e);
        }
    }
}

