/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.linkers;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.exactpro.cradle.cassandra.CassandraSemaphore;
import com.exactpro.cradle.cassandra.dao.AsyncOperator;
import com.exactpro.cradle.cassandra.dao.messages.MessageTestEventEntity;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventMessagesEntity;
import com.exactpro.cradle.cassandra.iterators.PagedIterator;
import com.exactpro.cradle.cassandra.linkers.LinkerSupplies;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.cassandra.retries.SelectQueryExecutor;
import com.exactpro.cradle.messages.StoredMessageId;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.TestEventsMessagesLinker;
import com.exactpro.cradle.utils.CradleIdException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

public class CassandraTestEventsMessagesLinker
implements TestEventsMessagesLinker {
    private final LinkerSupplies supplies;
    private final UUID instanceId;
    private final Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs;
    private final CassandraSemaphore semaphore;
    private final SelectQueryExecutor selectExec;
    private final PagingSupplies pagingSupplies;

    public CassandraTestEventsMessagesLinker(LinkerSupplies supplies, UUID instanceId, Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs, CassandraSemaphore semaphore, SelectQueryExecutor selectExec, PagingSupplies pagingSupplies) {
        this.supplies = supplies;
        this.instanceId = instanceId;
        this.readAttrs = readAttrs;
        this.semaphore = semaphore;
        this.selectExec = selectExec;
        this.pagingSupplies = pagingSupplies;
    }

    public Collection<StoredTestEventId> getTestEventIdsByMessageId(StoredMessageId messageId) throws IOException {
        try {
            return this.getTestEventIdsByMessageIdAsync(messageId).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting IDs of test events linked to message " + messageId, e);
        }
    }

    public CompletableFuture<Collection<StoredTestEventId>> getTestEventIdsByMessageIdAsync(StoredMessageId messageId) {
        String queryInfo = "get test events for messageId=" + messageId;
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.selectExec.executeMultiRowResultQuery(() -> this.supplies.getMessagesOperator().getTestEvents(this.instanceId, messageId.toString(), this.readAttrs), this.supplies.getMessageConverter(), queryInfo));
        return future.thenApplyAsync(rs -> {
            PagedIterator<MessageTestEventEntity> it = new PagedIterator<MessageTestEventEntity>((MappedAsyncPagingIterable<MessageTestEventEntity>)rs, this.pagingSupplies, this.supplies.getMessageConverter(), queryInfo);
            HashSet<StoredTestEventId> ids = new HashSet<StoredTestEventId>();
            while (it.hasNext()) {
                String eventId = it.next().getEventId();
                StoredTestEventId parsedId = new StoredTestEventId(eventId);
                ids.add(parsedId);
            }
            if (ids.isEmpty()) {
                ids = null;
            }
            return ids;
        });
    }

    public Collection<StoredMessageId> getMessageIdsByTestEventId(StoredTestEventId eventId) throws IOException {
        try {
            return this.getMessageIdsByTestEventIdAsync(eventId).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting IDs of messages linked to test event " + eventId, e);
        }
    }

    public CompletableFuture<Collection<StoredMessageId>> getMessageIdsByTestEventIdAsync(StoredTestEventId eventId) {
        String queryInfo = "get messages for eventId=" + eventId;
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.selectExec.executeMultiRowResultQuery(() -> this.supplies.getTestEventsOperator().getMessages(this.instanceId, eventId.toString(), this.readAttrs), this.supplies.getTestEventConverter(), queryInfo));
        return future.thenApplyAsync(rs -> {
            PagedIterator<TestEventMessagesEntity> it = new PagedIterator<TestEventMessagesEntity>((MappedAsyncPagingIterable<TestEventMessagesEntity>)rs, this.pagingSupplies, this.supplies.getTestEventConverter(), queryInfo);
            HashSet<StoredMessageId> ids = new HashSet<StoredMessageId>();
            while (it.hasNext()) {
                Set<String> currentMessageIds = it.next().getMessageIds();
                if (currentMessageIds == null) continue;
                for (String cid : currentMessageIds) {
                    try {
                        StoredMessageId parsedId = StoredMessageId.fromString((String)cid);
                        ids.add(parsedId);
                    }
                    catch (CradleIdException e) {
                        throw new CompletionException("Could not parse message ID from '" + cid + "'", e);
                    }
                }
            }
            if (ids.isEmpty()) {
                ids = null;
            }
            return ids;
        });
    }

    public boolean isTestEventLinkedToMessages(StoredTestEventId eventId) throws IOException {
        try {
            return this.isTestEventLinkedToMessagesAsync(eventId).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting if test event " + eventId + " has messages linked to it", e);
        }
    }

    public CompletableFuture<Boolean> isTestEventLinkedToMessagesAsync(StoredTestEventId eventId) {
        String queryInfo = "get messages for eventId=" + eventId + " to check links";
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.selectExec.executeMultiRowResultQuery(() -> this.supplies.getTestEventsOperator().getMessages(this.instanceId, eventId.toString(), this.readAttrs), this.supplies.getTestEventConverter(), queryInfo));
        return future.thenApplyAsync(rs -> {
            PagedIterator<TestEventMessagesEntity> it = new PagedIterator<TestEventMessagesEntity>((MappedAsyncPagingIterable<TestEventMessagesEntity>)rs, this.pagingSupplies, this.supplies.getTestEventConverter(), queryInfo);
            boolean result = false;
            while (it.hasNext()) {
                Set<String> ids = it.next().getMessageIds();
                if (ids == null || ids.isEmpty()) continue;
                result = true;
                break;
            }
            return result;
        });
    }

    public boolean isMessageLinkedToTestEvents(StoredMessageId messageId) throws IOException {
        try {
            return this.isMessageLinkedToTestEventsAsync(messageId).get();
        }
        catch (Exception e) {
            throw new IOException("Error while getting if message " + messageId + " has test events linked to it", e);
        }
    }

    public CompletableFuture<Boolean> isMessageLinkedToTestEventsAsync(StoredMessageId messageId) {
        String queryInfo = "get test events for messageId=" + messageId + " to check links";
        CompletableFuture future = new AsyncOperator(this.semaphore).getFuture(() -> this.selectExec.executeMultiRowResultQuery(() -> this.supplies.getMessagesOperator().getTestEvents(this.instanceId, messageId.toString(), this.readAttrs), this.supplies.getMessageConverter(), queryInfo));
        return future.thenApply(rs -> {
            PagedIterator<MessageTestEventEntity> it = new PagedIterator<MessageTestEventEntity>((MappedAsyncPagingIterable<MessageTestEventEntity>)rs, this.pagingSupplies, this.supplies.getMessageConverter(), queryInfo);
            return it.hasNext();
        });
    }
}

