/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.retries;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventEntity;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventConverter;
import com.exactpro.cradle.cassandra.iterators.TestEventDataIteratorAdapter;
import com.exactpro.cradle.cassandra.retries.CannotRetryException;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.cassandra.retries.RetryUtils;
import com.exactpro.cradle.cassandra.retries.SelectExecutionPolicy;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompleteEventsGetter {
    private static final Logger logger = LoggerFactory.getLogger(CompleteEventsGetter.class);
    private final UUID instanceId;
    private final Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs;
    private final SelectExecutionPolicy execPolicy;
    private final TestEventOperator operator;
    private final TestEventConverter converter;
    private final PagingSupplies pagingSupplies;

    public CompleteEventsGetter(UUID instanceId, Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs, SelectExecutionPolicy execPolicy, TestEventOperator operator, TestEventConverter converter, PagingSupplies pagingSupplies) {
        this.instanceId = instanceId;
        this.readAttrs = readAttrs;
        this.execPolicy = execPolicy;
        this.operator = operator;
        this.converter = converter;
        this.pagingSupplies = pagingSupplies;
    }

    public CompletableFuture<Iterable<StoredTestEventWrapper>> get(Collection<StoredTestEventId> ids, String queryInfo) {
        CompletableFuture<Iterable<StoredTestEventWrapper>> f = new CompletableFuture<Iterable<StoredTestEventWrapper>>();
        List<String> idStrings = ids.stream().map(StoredTestEventId::toString).collect(Collectors.toList());
        ((CompletableFuture)this.operator.getComplete(this.instanceId, idStrings, this.readAttrs).thenApplyAsync(r -> this.toCollection((MappedAsyncPagingIterable<TestEventEntity>)r, queryInfo))).whenCompleteAsync((result, error) -> this.onComplete((Iterable<StoredTestEventWrapper>)result, (Throwable)error, idStrings, f, queryInfo, 0));
        return f;
    }

    private Collection<StoredTestEventWrapper> toCollection(MappedAsyncPagingIterable<TestEventEntity> rs, String queryInfo) {
        ArrayList<StoredTestEventWrapper> result = new ArrayList<StoredTestEventWrapper>();
        new TestEventDataIteratorAdapter(rs, this.pagingSupplies, this.converter, queryInfo).forEach(event -> result.add((StoredTestEventWrapper)event));
        return result;
    }

    private void onComplete(Iterable<StoredTestEventWrapper> result, Throwable error, List<String> ids, CompletableFuture<Iterable<StoredTestEventWrapper>> f, String queryInfo, int retryCount) {
        List<List<String>> splitIds;
        if (error == null) {
            f.complete(result);
            return;
        }
        DriverException driverException = RetryUtils.getDriverException(error);
        if (driverException == null) {
            logger.error("Cannot retry '" + queryInfo + "' after non-driver exception", error);
            f.completeExceptionally(error);
            return;
        }
        try {
            splitIds = RetryUtils.applyPolicyVerdict(ids, this.execPolicy.onError(ids, queryInfo, error, retryCount));
        }
        catch (CannotRetryException e2) {
            f.completeExceptionally(e2);
            return;
        }
        ArrayList resultList = new ArrayList();
        CompletionStage<ArrayList<Object>> newResult = CompletableFuture.completedFuture(resultList);
        try {
            logger.debug("Retrying request ({}) '{}' with IDs list split into {} parts after error: '{}'", new Object[]{retryCount + 1, queryInfo, splitIds.size(), error.getMessage()});
            for (List<String> part : splitIds) {
                newResult = ((CompletableFuture)newResult.thenComposeAsync(r -> this.operator.getComplete(this.instanceId, part, this.readAttrs))).thenApplyAsync(rs -> {
                    resultList.addAll(this.toCollection((MappedAsyncPagingIterable<TestEventEntity>)rs, queryInfo));
                    return resultList;
                });
            }
            newResult.whenCompleteAsync((r, e) -> this.onComplete((Iterable<StoredTestEventWrapper>)r, (Throwable)e, ids, f, queryInfo, retryCount + 1));
        }
        catch (Exception e3) {
            logger.error("Error while retrying '" + queryInfo + "'", (Throwable)e3);
            f.completeExceptionally(e3);
        }
    }
}

