/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.retries;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.exactpro.cradle.cassandra.retries.SelectExecutionVerdict;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RetryUtils {
    private static final long BASE_DELAYS_MS = 1000L;
    private static final long MAX_DELAYS_MS = 10000L;

    public static DriverException getDriverException(Throwable e) {
        if (e instanceof DriverException) {
            return (DriverException)e;
        }
        Throwable cause = e.getCause();
        return cause == null ? null : RetryUtils.getDriverException(cause);
    }

    public static boolean isRetriableException(Throwable e) {
        if (e instanceof DriverTimeoutException || e instanceof FrameTooLongException) {
            return true;
        }
        Throwable cause = e.getCause();
        return cause == null ? false : RetryUtils.isRetriableException(cause);
    }

    public static Statement<?> applyPolicyVerdict(Statement<?> stmt, SelectExecutionVerdict policyVerdict) {
        int pageSize;
        if (policyVerdict == null) {
            return stmt;
        }
        ConsistencyLevel cl = policyVerdict.getConsistencyLevel();
        if (cl != null) {
            stmt = stmt.setConsistencyLevel(cl);
        }
        if ((pageSize = policyVerdict.getPageSize()) > 0) {
            stmt = stmt.setPageSize(pageSize);
        }
        return stmt;
    }

    public static List<List<String>> applyPolicyVerdict(List<String> ids, SelectExecutionVerdict policyVerdict) {
        if (policyVerdict == null) {
            return Collections.singletonList(ids);
        }
        int pageSize = policyVerdict.getPageSize();
        if (pageSize <= 0) {
            return Collections.singletonList(ids);
        }
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int length = ids.size();
        for (int i = 0; i < length / pageSize; ++i) {
            int index = i * pageSize;
            result.add(ids.subList(index, index + pageSize));
        }
        int tail = length % pageSize;
        if (tail > 0) {
            result.add(ids.subList(length - tail, length));
        }
        return result;
    }

    public static long calculateDelayWithJitter(int retryCount) {
        long delay = Math.min(1000L * (1L << retryCount++), 10000L);
        int jitter = ThreadLocalRandom.current().nextInt(85, 116);
        delay = (long)jitter * delay / 100L;
        delay = Math.min(10000L, Math.max(1000L, delay));
        return delay;
    }
}

