/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.utils;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.io.IOException;
import java.time.Duration;

public class QueryExecutor {
    private final CqlSession session;
    private final long timeout;
    private final ConsistencyLevel writeConsistencyLevel;
    private final ConsistencyLevel readConsistencyLevel;

    public QueryExecutor(CqlSession session, long timeout, ConsistencyLevel writeConsistencyLevel, ConsistencyLevel readConsistencyLevel) {
        this.session = session;
        this.timeout = timeout;
        this.writeConsistencyLevel = writeConsistencyLevel;
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public ResultSet executeQuery(String cqlQuery, boolean writingQuery) throws IOException {
        ResultSet rs = this.session.execute((Statement)this.makeSimpleStatement(cqlQuery, writingQuery ? this.writeConsistencyLevel : this.readConsistencyLevel));
        if (!rs.wasApplied()) {
            throw new IOException("Query was rejected by database. Probably, key fields are duplicated. Rejected query: " + cqlQuery);
        }
        return rs;
    }

    public CqlSession getSession() {
        return this.session;
    }

    private SimpleStatement makeSimpleStatement(String query, ConsistencyLevel consistencyLevel) {
        return (SimpleStatement)((SimpleStatement)SimpleStatement.newInstance((String)query).setTimeout(Duration.ofMillis(this.timeout))).setConsistencyLevel(consistencyLevel);
    }
}

