/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra;

import com.exactpro.cradle.CradleManager;
import com.exactpro.cradle.CradleStorage;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.cassandra.CassandraStorageSettings;
import com.exactpro.cradle.cassandra.connection.CassandraConnection;
import com.exactpro.cradle.cassandra.connection.CassandraConnectionSettings;

public class CassandraCradleManager
extends CradleManager {
    private final CassandraConnection connection;

    public CassandraCradleManager(CassandraConnection connection) {
        this.connection = connection;
    }

    protected CradleStorage createStorage(long maxMessageBatchSize, long maxTestEventBatchSize) {
        CassandraConnectionSettings settings = this.connection.getSettings();
        CassandraStorageSettings storageSettings = this.createStorageSettings(settings, maxMessageBatchSize, maxTestEventBatchSize);
        return new CassandraCradleStorage(this.connection, storageSettings);
    }

    protected CassandraStorageSettings createStorageSettings(CassandraConnectionSettings connectionSettings, long maxMessageBatchSize, long maxTestEventBatchSize) {
        CassandraStorageSettings result = new CassandraStorageSettings(connectionSettings.getKeyspace(), connectionSettings.getNetworkTopologyStrategy(), connectionSettings.getTimeout() <= 0L ? 5000L : connectionSettings.getTimeout(), connectionSettings.getWriteConsistencyLevel() == null ? CassandraStorageSettings.DEFAULT_CONSISTENCY_LEVEL : connectionSettings.getWriteConsistencyLevel(), connectionSettings.getReadConsistencyLevel() == null ? CassandraStorageSettings.DEFAULT_CONSISTENCY_LEVEL : connectionSettings.getReadConsistencyLevel());
        if (maxMessageBatchSize > 0L) {
            result.setMaxMessageBatchSize(maxMessageBatchSize);
        }
        if (maxTestEventBatchSize > 0L) {
            result.setMaxTestEventBatchSize(maxTestEventBatchSize);
        }
        return result;
    }
}

