/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra;

import java.util.concurrent.Semaphore;

public class CassandraSemaphore {
    private final int maxParallelQueries;
    private final Semaphore semaphore;

    public CassandraSemaphore(int maxParallelQueries) {
        this.maxParallelQueries = maxParallelQueries;
        this.semaphore = new Semaphore(maxParallelQueries, true);
    }

    public void acquireSemaphore() throws InterruptedException {
        this.semaphore.acquire();
    }

    public void releaseSemaphore() {
        this.semaphore.release();
    }

    public int getMaxQueriesNumber() {
        return this.maxParallelQueries;
    }

    public int getAquiredQueriesNumber() throws InterruptedException {
        return this.maxParallelQueries - this.semaphore.availablePermits();
    }
}

