/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.exactpro.cradle.cassandra.connection.NetworkTopologyStrategy;

public class CassandraStorageSettings {
    public static final int MESSAGE_BATCH_SIZE_LIMIT_BYTES = 5000;
    public static final int TEST_EVENT_BATCH_SIZE_LIMIT_BYTES = 5000;
    public static final String DEFAULT_KEYSPACE = "cradle";
    public static final String INSTANCES_TABLE_DEFAULT_NAME = "instances";
    public static final String MESSAGES_TABLE_DEFAULT_NAME = "messages";
    public static final String PROCESSED_MESSAGES_TABLE_DEFAULT_NAME = "processed_messages";
    public static final String TIME_MESSAGES_TABLE_DEFAULT_NAME = "messages_timestamps";
    public static final String TEST_EVENTS_TABLE_DEFAULT_NAME = "test_events";
    public static final String TIME_TEST_EVENTS_TABLE_DEFAULT_NAME = "time_test_events";
    public static final String ROOT_TEST_EVENTS_TABLE_DEFAULT_NAME = "root_test_events";
    public static final String TEST_EVENTS_CHILDREN_TABLE_DEFAULT_NAME = "test_events_children";
    public static final String TEST_EVENTS_CHILDREN_DATES_TABLE_DEFAULT_NAME = "test_events_children_dates";
    public static final String INTERVALS_TABLE_DEFAULT_NAME = "intervals";
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final long DEFAULT_MAX_MESSAGE_BATCH_SIZE = 0x100000L;
    public static final long DEFAULT_MAX_EVENT_BATCH_SIZE = 0x100000L;
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.LOCAL_QUORUM;
    public static final int DEFAULT_KEYSPACE_REPL_FACTOR = 1;
    private final String keyspace;
    private String messagesTableName = "messages";
    private String timeMessagesTableName = "messages_timestamps";
    private String processedMessagesTableName = "processed_messages";
    private String testEventsTableName = "test_events";
    private String timeTestEventsTableName = "time_test_events";
    private String rootTestEventsTableName = "root_test_events";
    private String testEventsChildrenTableName = "test_events_children";
    private String testEventsChildrenDatesTableName = "test_events_children_dates";
    private String timeIntervalsTableName;
    private String intervalsTableName = "intervals";
    private final NetworkTopologyStrategy networkTopologyStrategy;
    private long timeout;
    private ConsistencyLevel writeConsistencyLevel;
    private ConsistencyLevel readConsistencyLevel;
    private int keyspaceReplicationFactor;
    private long maxMessageBatchSize;
    private long maxTestEventBatchSize;

    public CassandraStorageSettings(String keyspace, NetworkTopologyStrategy networkTopologyStrategy, long timeout, ConsistencyLevel writeConsistencyLevel, ConsistencyLevel readConsistencyLevel) {
        this.keyspace = keyspace;
        this.networkTopologyStrategy = networkTopologyStrategy;
        this.timeout = timeout;
        this.writeConsistencyLevel = writeConsistencyLevel;
        this.readConsistencyLevel = readConsistencyLevel;
        this.keyspaceReplicationFactor = 1;
        this.maxMessageBatchSize = 0x100000L;
        this.maxTestEventBatchSize = 0x100000L;
    }

    public CassandraStorageSettings(String keyspace, NetworkTopologyStrategy networkTopology) {
        this(keyspace, networkTopology, 5000L, DEFAULT_CONSISTENCY_LEVEL, DEFAULT_CONSISTENCY_LEVEL);
    }

    public CassandraStorageSettings(String keyspace) {
        this(keyspace, null, 5000L, DEFAULT_CONSISTENCY_LEVEL, DEFAULT_CONSISTENCY_LEVEL);
    }

    public CassandraStorageSettings() {
        this(DEFAULT_KEYSPACE, null, 5000L, DEFAULT_CONSISTENCY_LEVEL, DEFAULT_CONSISTENCY_LEVEL);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public NetworkTopologyStrategy getNetworkTopologyStrategy() {
        return this.networkTopologyStrategy;
    }

    public String getMessagesTableName() {
        return this.messagesTableName;
    }

    public void setMessagesTableName(String messagesTableName) {
        this.messagesTableName = messagesTableName;
    }

    public String getProcessedMessagesTableName() {
        return this.processedMessagesTableName;
    }

    public void setProcessedMessagesTableName(String processedMessagesTableName) {
        this.processedMessagesTableName = processedMessagesTableName;
    }

    public String getTimeMessagesTableName() {
        return this.timeMessagesTableName;
    }

    public void setTimeMessagesTableName(String timeMessagesTableName) {
        this.timeMessagesTableName = timeMessagesTableName;
    }

    public String getTestEventsTableName() {
        return this.testEventsTableName;
    }

    public void setTestEventsTableName(String testEventsTableName) {
        this.testEventsTableName = testEventsTableName;
    }

    public String getTimeTestEventsTableName() {
        return this.timeTestEventsTableName;
    }

    public void setTimeTestEventsTableName(String timeTestEventsTableName) {
        this.timeTestEventsTableName = timeTestEventsTableName;
    }

    public String getRootTestEventsTableName() {
        return this.rootTestEventsTableName;
    }

    public void setRootTestEventsTableName(String rootTestEventsTableName) {
        this.rootTestEventsTableName = rootTestEventsTableName;
    }

    public String getTestEventsChildrenTableName() {
        return this.testEventsChildrenTableName;
    }

    public void setTestEventsChildrenTableName(String testEventsChildrenTableName) {
        this.testEventsChildrenTableName = testEventsChildrenTableName;
    }

    public String getTestEventsChildrenDatesTableName() {
        return this.testEventsChildrenDatesTableName;
    }

    public void setTestEventsChildrenDatesTableName(String testEventsChildrenDatesTableName) {
        this.testEventsChildrenDatesTableName = testEventsChildrenDatesTableName;
    }

    public String getIntervalsTableName() {
        return this.intervalsTableName;
    }

    public String getTimeIntervalsTableName() {
        return this.timeIntervalsTableName;
    }

    public void setIntervalsTableName(String intervalsTableName) {
        this.intervalsTableName = intervalsTableName;
    }

    public int getKeyspaceReplicationFactor() {
        return this.keyspaceReplicationFactor;
    }

    public void setKeyspaceReplicationFactor(int keyspaceReplicationFactor) {
        this.keyspaceReplicationFactor = keyspaceReplicationFactor;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public long getMaxMessageBatchSize() {
        return this.maxMessageBatchSize;
    }

    public void setMaxMessageBatchSize(long maxMessageBatchSize) {
        this.maxMessageBatchSize = maxMessageBatchSize;
    }

    public long getMaxTestEventBatchSize() {
        return this.maxTestEventBatchSize;
    }

    public void setMaxTestEventBatchSize(long maxTestEventBatchSize) {
        this.maxTestEventBatchSize = maxTestEventBatchSize;
    }
}

