/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.connection;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.exactpro.cradle.cassandra.connection.CassandraConnectionSettings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class CassandraConnection {
    public static final String DRIVER_CONFIG_FILE_NAME = "application.conf";
    private static final Path DRIVER_CONFIG = Paths.get(System.getProperty("user.dir"), "application.conf");
    private CassandraConnectionSettings settings;
    private CqlSession session;
    private Date started;
    private Date stopped;

    public CassandraConnection() {
        this.settings = this.createSettings();
    }

    public CassandraConnection(CassandraConnectionSettings settings) {
        this.settings = settings;
    }

    public void start() throws Exception {
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        sessionBuilder.withConfigLoader(this.getConfigLoader());
        if (!StringUtils.isEmpty((CharSequence)this.settings.getLocalDataCenter())) {
            sessionBuilder = (CqlSessionBuilder)sessionBuilder.withLocalDatacenter(this.settings.getLocalDataCenter());
        }
        if (this.settings.getPort() > -1) {
            sessionBuilder = (CqlSessionBuilder)sessionBuilder.addContactPoint(new InetSocketAddress(this.settings.getHost(), this.settings.getPort()));
        }
        if (!StringUtils.isEmpty((CharSequence)this.settings.getUsername())) {
            sessionBuilder = (CqlSessionBuilder)sessionBuilder.withAuthCredentials(this.settings.getUsername(), this.settings.getPassword());
        }
        this.session = (CqlSession)sessionBuilder.build();
        this.started = new Date();
    }

    private DriverConfigLoader getConfigLoader() {
        Supplier<Config> fallBackSupplier = () -> {
            Config config = ConfigFactory.defaultApplication();
            if (Files.exists(DRIVER_CONFIG, new LinkOption[0])) {
                config = config.withFallback((ConfigMergeable)ConfigFactory.parseFileAnySyntax((File)DRIVER_CONFIG.toFile()));
            }
            return config.withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve();
        };
        long queryTimeout = this.settings.getTimeout() == 0L ? 5000L : this.settings.getTimeout();
        return new DefaultProgrammaticDriverConfigLoaderBuilder(fallBackSupplier, "datastax-java-driver").withDuration((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, Duration.ofMillis(queryTimeout)).build();
    }

    public void stop() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
        this.stopped = new Date();
    }

    public CassandraConnectionSettings getSettings() {
        return this.settings;
    }

    public void setSettings(CassandraConnectionSettings settings) {
        this.settings = settings;
    }

    public CqlSession getSession() {
        return this.session;
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getStopped() {
        return this.stopped;
    }

    protected CassandraConnectionSettings createSettings() {
        return new CassandraConnectionSettings();
    }
}

