/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.connection;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.exactpro.cradle.cassandra.connection.NetworkTopologyStrategy;
import com.exactpro.cradle.cassandra.retries.SelectExecutionPolicy;

public class CassandraConnectionSettings {
    private String localDataCenter = "";
    private String host = "";
    private int port = -1;
    private String keyspace = "";
    private String username = "";
    private String password = "";
    private long timeout = 0L;
    private ConsistencyLevel writeConsistencyLevel = null;
    private ConsistencyLevel readConsistencyLevel = null;
    private NetworkTopologyStrategy networkTopologyStrategy = null;
    private int maxParallelQueries = 500;
    private int resultPageSize = 0;
    private SelectExecutionPolicy selectExecutionPolicy = null;
    private SelectExecutionPolicy singleRowResultExecutionPolicy = null;

    public CassandraConnectionSettings() {
    }

    public CassandraConnectionSettings(String localDataCenter, String host, int port, String keyspace) {
        this();
        this.localDataCenter = localDataCenter;
        this.host = host;
        this.port = port;
        this.keyspace = keyspace;
    }

    public CassandraConnectionSettings(CassandraConnectionSettings settings) {
        this();
        this.localDataCenter = settings.localDataCenter;
        this.host = settings.host;
        this.port = settings.port;
        this.keyspace = settings.keyspace;
        this.username = settings.username;
        this.password = settings.password;
        this.timeout = settings.timeout;
        this.writeConsistencyLevel = settings.writeConsistencyLevel;
        this.readConsistencyLevel = settings.readConsistencyLevel;
        this.networkTopologyStrategy = settings.getNetworkTopologyStrategy() != null ? new NetworkTopologyStrategy(settings.getNetworkTopologyStrategy().asMap()) : null;
        this.maxParallelQueries = settings.maxParallelQueries;
        this.resultPageSize = settings.resultPageSize;
        this.selectExecutionPolicy = settings.selectExecutionPolicy;
        this.singleRowResultExecutionPolicy = settings.singleRowResultExecutionPolicy;
    }

    public String getLocalDataCenter() {
        return this.localDataCenter;
    }

    public void setLocalDataCenter(String localDataCenter) {
        this.localDataCenter = localDataCenter;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public NetworkTopologyStrategy getNetworkTopologyStrategy() {
        return this.networkTopologyStrategy;
    }

    public void setNetworkTopologyStrategy(NetworkTopologyStrategy networkTopologyStrategy) {
        this.networkTopologyStrategy = networkTopologyStrategy;
    }

    public int getMaxParallelQueries() {
        return this.maxParallelQueries;
    }

    public void setMaxParallelQueries(int maxParallelQueries) {
        this.maxParallelQueries = maxParallelQueries;
    }

    public int getResultPageSize() {
        return this.resultPageSize;
    }

    public void setResultPageSize(int resultPageSize) {
        this.resultPageSize = resultPageSize;
    }

    public SelectExecutionPolicy getSelectExecutionPolicy() {
        return this.selectExecutionPolicy;
    }

    public void setSelectExecutionPolicy(SelectExecutionPolicy selectExecutionPolicy) {
        this.selectExecutionPolicy = selectExecutionPolicy;
    }

    public SelectExecutionPolicy getSingleRowResultExecutionPolicy() {
        return this.singleRowResultExecutionPolicy;
    }

    public void setSingleRowResultExecutionPolicy(SelectExecutionPolicy singleRowResultExecutionPolicy) {
        this.singleRowResultExecutionPolicy = singleRowResultExecutionPolicy;
    }
}

