/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao;

import com.exactpro.cradle.cassandra.CassandraStorageSettings;
import com.exactpro.cradle.cassandra.dao.CassandraDataMapper;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalOperator;
import com.exactpro.cradle.cassandra.dao.intervals.converters.DateTimeEventEntityConverter;
import com.exactpro.cradle.cassandra.dao.intervals.converters.IntervalConverter;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchOperator;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageOperator;
import com.exactpro.cradle.cassandra.dao.messages.converters.DetailedMessageBatchConverter;
import com.exactpro.cradle.cassandra.dao.messages.converters.TimeMessageConverter;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventChildrenDatesOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.TimeTestEventOperator;
import com.exactpro.cradle.cassandra.dao.testevents.converters.DateEventEntityConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.DetailedTestEventConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventConverter;
import com.exactpro.cradle.cassandra.dao.testevents.converters.TestEventMetadataConverter;

public class CassandraOperators {
    private final MessageBatchOperator messageBatchOperator;
    private final MessageBatchOperator processedMessageBatchOperator;
    private final TimeMessageOperator timeMessageOperator;
    private final TestEventOperator testEventOperator;
    private final TimeTestEventOperator timeTestEventOperator;
    private final TestEventChildrenDatesOperator testEventChildrenDatesOperator;
    private final IntervalOperator intervalOperator;
    private final DetailedMessageBatchConverter messageBatchConverter;
    private final TestEventConverter testEventConverter;
    private final DetailedTestEventConverter detailedTestEventConverter;
    private final TestEventMetadataConverter testEventMetadataConverter;
    private final IntervalConverter intervalConverter;
    private final TimeMessageConverter timeMessageConverter;
    private final DateTimeEventEntityConverter dateTimeEventEntityConverter;
    private final DateEventEntityConverter dateEventEntityConverter;

    public CassandraOperators(CassandraDataMapper dataMapper, CassandraStorageSettings settings) {
        this.messageBatchOperator = dataMapper.messageBatchOperator(settings.getKeyspace(), settings.getMessagesTableName());
        this.processedMessageBatchOperator = dataMapper.messageBatchOperator(settings.getKeyspace(), settings.getProcessedMessagesTableName());
        this.timeMessageOperator = dataMapper.timeMessageOperator(settings.getKeyspace(), settings.getTimeMessagesTableName());
        this.testEventOperator = dataMapper.testEventOperator(settings.getKeyspace(), settings.getTestEventsTableName());
        this.timeTestEventOperator = dataMapper.timeTestEventOperator(settings.getKeyspace(), settings.getTimeTestEventsTableName());
        this.testEventChildrenDatesOperator = dataMapper.testEventChildrenDatesOperator(settings.getKeyspace(), settings.getTestEventsChildrenDatesTableName());
        this.intervalOperator = dataMapper.intervalOperator(settings.getKeyspace(), settings.getIntervalsTableName());
        this.messageBatchConverter = dataMapper.detailedMessageBatchConverter();
        this.testEventConverter = dataMapper.testEventConverter();
        this.detailedTestEventConverter = dataMapper.detailedTestEventConverter();
        this.testEventMetadataConverter = dataMapper.testEventMetadataConverter();
        this.intervalConverter = dataMapper.intervalConverter();
        this.timeMessageConverter = dataMapper.timeMessageConverter();
        this.dateTimeEventEntityConverter = dataMapper.dateTimeEventEntityConverter();
        this.dateEventEntityConverter = dataMapper.dateEventEntityConverter();
    }

    public MessageBatchOperator getMessageBatchOperator() {
        return this.messageBatchOperator;
    }

    public MessageBatchOperator getProcessedMessageBatchOperator() {
        return this.processedMessageBatchOperator;
    }

    public TimeMessageOperator getTimeMessageOperator() {
        return this.timeMessageOperator;
    }

    public TestEventOperator getTestEventOperator() {
        return this.testEventOperator;
    }

    public TimeTestEventOperator getTimeTestEventOperator() {
        return this.timeTestEventOperator;
    }

    public TestEventChildrenDatesOperator getTestEventChildrenDatesOperator() {
        return this.testEventChildrenDatesOperator;
    }

    public IntervalOperator getIntervalOperator() {
        return this.intervalOperator;
    }

    public DetailedMessageBatchConverter getMessageBatchConverter() {
        return this.messageBatchConverter;
    }

    public TestEventConverter getTestEventConverter() {
        return this.testEventConverter;
    }

    public TestEventMetadataConverter getTestEventMetadataConverter() {
        return this.testEventMetadataConverter;
    }

    public IntervalConverter getIntervalConverter() {
        return this.intervalConverter;
    }

    public TimeMessageConverter getTimeMessageConverter() {
        return this.timeMessageConverter;
    }

    public DateTimeEventEntityConverter getDateTimeEventEntityConverter() {
        return this.dateTimeEventEntityConverter;
    }

    public DetailedTestEventConverter getDetailedTestEventConverter() {
        return this.detailedTestEventConverter;
    }

    public DateEventEntityConverter getDateEventEntityConverter() {
        return this.dateEventEntityConverter;
    }
}

