/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.intervals;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.DaoBase;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalEntity;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalEntityHelper__MapperGenerated;
import com.exactpro.cradle.cassandra.dao.intervals.IntervalOperator;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalOperatorImpl__MapperGenerated
extends DaoBase
implements IntervalOperator {
    private static final Logger LOG = LoggerFactory.getLogger(IntervalOperatorImpl__MapperGenerated.class);
    private final IntervalEntityHelper__MapperGenerated intervalEntityHelper;
    private final PreparedStatement writeIntervalStatement;
    private final PreparedStatement getIntervalsStatement;
    private final PreparedStatement setIntervalLastUpdateTimeAndDateStatement;
    private final PreparedStatement updateRecoveryStateStatement;
    private final PreparedStatement setIntervalProcessedStatement;

    private IntervalOperatorImpl__MapperGenerated(MapperContext context, IntervalEntityHelper__MapperGenerated intervalEntityHelper, PreparedStatement writeIntervalStatement, PreparedStatement getIntervalsStatement, PreparedStatement setIntervalLastUpdateTimeAndDateStatement, PreparedStatement updateRecoveryStateStatement, PreparedStatement setIntervalProcessedStatement) {
        super(context);
        this.intervalEntityHelper = intervalEntityHelper;
        this.writeIntervalStatement = writeIntervalStatement;
        this.getIntervalsStatement = getIntervalsStatement;
        this.setIntervalLastUpdateTimeAndDateStatement = setIntervalLastUpdateTimeAndDateStatement;
        this.updateRecoveryStateStatement = updateRecoveryStateStatement;
        this.setIntervalProcessedStatement = setIntervalProcessedStatement;
    }

    @Override
    public CompletableFuture<AsyncResultSet> writeInterval(IntervalEntity IntervalEntity2, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.writeIntervalStatement.boundStatementBuilder(new Object[0]);
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            this.intervalEntityHelper.set(IntervalEntity2, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsync((Statement)boundStatement);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MappedAsyncPagingIterable<IntervalEntity>> getIntervals(UUID instanceId, LocalDate intervalStartDate, LocalTime intervalStartTime, LocalTime intervalEndTime, String crawlerName, String crawlerVersion, String crawlerType, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.getIntervalsStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (intervalStartDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartDate", (Object)intervalStartDate, LocalDate.class);
            }
            if (intervalStartTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartTime", (Object)intervalStartTime, LocalTime.class);
            }
            if (intervalEndTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalEndTime", (Object)intervalEndTime, LocalTime.class);
            }
            if (crawlerName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerName", (Object)crawlerName, String.class);
            }
            if (crawlerVersion != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerVersion", (Object)crawlerVersion, String.class);
            }
            if (crawlerType != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerType", (Object)crawlerType, String.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToEntityIterable((Statement)boundStatement, (EntityHelper)this.intervalEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AsyncResultSet> setIntervalLastUpdateTimeAndDate(UUID instanceId, LocalDate intervalStartDate, LocalTime intervalStartTime, LocalTime lastUpdateTime, LocalDate lastUpdateDate, LocalTime previousLastUpdateTime, LocalDate previousLastUpdateDate, String crawlerName, String crawlerVersion, String crawlerType, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.setIntervalLastUpdateTimeAndDateStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (intervalStartDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartDate", (Object)intervalStartDate, LocalDate.class);
            }
            if (intervalStartTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartTime", (Object)intervalStartTime, LocalTime.class);
            }
            if (lastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateTime", (Object)lastUpdateTime, LocalTime.class);
            }
            if (lastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateDate", (Object)lastUpdateDate, LocalDate.class);
            }
            if (previousLastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateTime", (Object)previousLastUpdateTime, LocalTime.class);
            }
            if (previousLastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateDate", (Object)previousLastUpdateDate, LocalDate.class);
            }
            if (crawlerName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerName", (Object)crawlerName, String.class);
            }
            if (crawlerVersion != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerVersion", (Object)crawlerVersion, String.class);
            }
            if (crawlerType != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerType", (Object)crawlerType, String.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsync((Statement)boundStatement);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AsyncResultSet> updateRecoveryState(UUID instanceId, LocalDate intervalDate, LocalTime intervalStartTime, LocalTime lastUpdateTime, LocalDate lastUpdateDate, String recoveryStateJson, String previousRecoveryStateJson, LocalTime previousLastUpdateTime, LocalDate previousLastUpdateDate, String crawlerName, String crawlerVersion, String crawlerType, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.updateRecoveryStateStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (intervalDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalDate", (Object)intervalDate, LocalDate.class);
            }
            if (intervalStartTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartTime", (Object)intervalStartTime, LocalTime.class);
            }
            if (lastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateTime", (Object)lastUpdateTime, LocalTime.class);
            }
            if (lastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateDate", (Object)lastUpdateDate, LocalDate.class);
            }
            if (recoveryStateJson != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("recoveryStateJson", (Object)recoveryStateJson, String.class);
            }
            if (previousRecoveryStateJson != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousRecoveryStateJson", (Object)previousRecoveryStateJson, String.class);
            }
            if (previousLastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateTime", (Object)previousLastUpdateTime, LocalTime.class);
            }
            if (previousLastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateDate", (Object)previousLastUpdateDate, LocalDate.class);
            }
            if (crawlerName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerName", (Object)crawlerName, String.class);
            }
            if (crawlerVersion != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerVersion", (Object)crawlerVersion, String.class);
            }
            if (crawlerType != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerType", (Object)crawlerType, String.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsync((Statement)boundStatement);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AsyncResultSet> setIntervalProcessed(UUID instanceId, LocalDate intervalDate, LocalTime intervalStartTime, LocalTime lastUpdateTime, LocalDate lastUpdateDate, boolean processed, boolean previousProcessed, LocalTime previousLastUpdateTime, LocalDate previousLastUpdateDate, String crawlerName, String crawlerVersion, String crawlerType, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.setIntervalProcessedStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (intervalDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalDate", (Object)intervalDate, LocalDate.class);
            }
            if (intervalStartTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("intervalStartTime", (Object)intervalStartTime, LocalTime.class);
            }
            if (lastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateTime", (Object)lastUpdateTime, LocalTime.class);
            }
            if (lastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("lastUpdateDate", (Object)lastUpdateDate, LocalDate.class);
            }
            boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.setBoolean("processed", processed);
            boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.setBoolean("previousProcessed", previousProcessed);
            if (previousLastUpdateTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateTime", (Object)previousLastUpdateTime, LocalTime.class);
            }
            if (previousLastUpdateDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("previousLastUpdateDate", (Object)previousLastUpdateDate, LocalDate.class);
            }
            if (crawlerName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerName", (Object)crawlerName, String.class);
            }
            if (crawlerVersion != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerVersion", (Object)crawlerVersion, String.class);
            }
            if (crawlerType != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("crawlerType", (Object)crawlerType, String.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsync((Statement)boundStatement);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static CompletableFuture<IntervalOperator> initAsync(MapperContext context) {
        LOG.debug("[{}] Initializing new instance for keyspace = {} and table = {}", new Object[]{context.getSession().getName(), context.getKeyspaceId(), context.getTableId()});
        IntervalOperatorImpl__MapperGenerated.throwIfProtocolVersionV3((MapperContext)context);
        try {
            IntervalEntityHelper__MapperGenerated intervalEntityHelper = new IntervalEntityHelper__MapperGenerated(context);
            if (((Boolean)context.getCustomState().get("datastax.mapper.schemaValidationEnabled")).booleanValue()) {
                intervalEntityHelper.validateEntityFields();
            }
            ArrayList<CompletionStage> prepareStages = new ArrayList<CompletionStage>();
            SimpleStatement writeIntervalStatement_simple = intervalEntityHelper.insert().ifNotExists().build();
            LOG.debug("[{}] Preparing query `{}` for method writeInterval(com.exactpro.cradle.cassandra.dao.intervals.IntervalEntity,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)writeIntervalStatement_simple.getQuery());
            CompletionStage writeIntervalStatement = IntervalOperatorImpl__MapperGenerated.prepare((SimpleStatement)writeIntervalStatement_simple, (MapperContext)context);
            prepareStages.add(writeIntervalStatement);
            SimpleStatement getIntervalsStatement_simple = IntervalOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND interval_start_date=:intervalStartDate AND crawler_name=:crawlerName AND crawler_version=:crawlerVersion AND crawler_type=:crawlerType AND interval_start_time>=:intervalStartTime AND interval_start_time<=:intervalEndTime", (MapperContext)context, (EntityHelper)intervalEntityHelper);
            LOG.debug("[{}] Preparing query `{}` for method getIntervals(java.util.UUID,java.time.LocalDate,java.time.LocalTime,java.time.LocalTime,java.lang.String,java.lang.String,java.lang.String,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)getIntervalsStatement_simple.getQuery());
            CompletionStage getIntervalsStatement = IntervalOperatorImpl__MapperGenerated.prepare((SimpleStatement)getIntervalsStatement_simple, (MapperContext)context);
            prepareStages.add(getIntervalsStatement);
            SimpleStatement setIntervalLastUpdateTimeAndDateStatement_simple = IntervalOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"UPDATE ${qualifiedTableId} SET interval_last_update_time=:lastUpdateTime, interval_last_update_date=:lastUpdateDate WHERE instance_id=:instanceId AND interval_start_date=:intervalStartDate AND crawler_name=:crawlerName AND crawler_version=:crawlerVersion AND crawler_type=:crawlerType AND interval_start_time=:intervalStartTime IF interval_last_update_time=:previousLastUpdateTime AND interval_last_update_date=:previousLastUpdateDate", (MapperContext)context, null);
            LOG.debug("[{}] Preparing query `{}` for method setIntervalLastUpdateTimeAndDate(java.util.UUID,java.time.LocalDate,java.time.LocalTime,java.time.LocalTime,java.time.LocalDate,java.time.LocalTime,java.time.LocalDate,java.lang.String,java.lang.String,java.lang.String,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)setIntervalLastUpdateTimeAndDateStatement_simple.getQuery());
            CompletionStage setIntervalLastUpdateTimeAndDateStatement = IntervalOperatorImpl__MapperGenerated.prepare((SimpleStatement)setIntervalLastUpdateTimeAndDateStatement_simple, (MapperContext)context);
            prepareStages.add(setIntervalLastUpdateTimeAndDateStatement);
            SimpleStatement updateRecoveryStateStatement_simple = IntervalOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"UPDATE ${qualifiedTableId} SET recovery_state_json=:recoveryStateJson, interval_last_update_time=:lastUpdateTime, interval_last_update_date=:lastUpdateDate WHERE instance_id=:instanceId AND interval_start_date=:intervalDate AND crawler_name=:crawlerName AND crawler_version=:crawlerVersion AND crawler_type=:crawlerType AND interval_start_time=:intervalStartTime IF recovery_state_json=:previousRecoveryStateJson AND interval_last_update_time=:previousLastUpdateTime AND interval_last_update_date=:previousLastUpdateDate", (MapperContext)context, null);
            LOG.debug("[{}] Preparing query `{}` for method updateRecoveryState(java.util.UUID,java.time.LocalDate,java.time.LocalTime,java.time.LocalTime,java.time.LocalDate,java.lang.String,java.lang.String,java.time.LocalTime,java.time.LocalDate,java.lang.String,java.lang.String,java.lang.String,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)updateRecoveryStateStatement_simple.getQuery());
            CompletionStage updateRecoveryStateStatement = IntervalOperatorImpl__MapperGenerated.prepare((SimpleStatement)updateRecoveryStateStatement_simple, (MapperContext)context);
            prepareStages.add(updateRecoveryStateStatement);
            SimpleStatement setIntervalProcessedStatement_simple = IntervalOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"UPDATE ${qualifiedTableId} SET interval_processed=:processed, interval_last_update_time=:lastUpdateTime, interval_last_update_date=:lastUpdateDate WHERE instance_id=:instanceId AND interval_start_date=:intervalDate AND crawler_name=:crawlerName AND crawler_version=:crawlerVersion AND crawler_type=:crawlerType AND interval_start_time=:intervalStartTime IF interval_processed=:previousProcessed AND interval_last_update_time=:previousLastUpdateTime AND interval_last_update_date=:previousLastUpdateDate", (MapperContext)context, null);
            LOG.debug("[{}] Preparing query `{}` for method setIntervalProcessed(java.util.UUID,java.time.LocalDate,java.time.LocalTime,java.time.LocalTime,java.time.LocalDate,boolean,boolean,java.time.LocalTime,java.time.LocalDate,java.lang.String,java.lang.String,java.lang.String,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)setIntervalProcessedStatement_simple.getQuery());
            CompletionStage setIntervalProcessedStatement = IntervalOperatorImpl__MapperGenerated.prepare((SimpleStatement)setIntervalProcessedStatement_simple, (MapperContext)context);
            prepareStages.add(setIntervalProcessedStatement);
            return CompletableFutures.allSuccessful(prepareStages).thenApply(v -> new IntervalOperatorImpl__MapperGenerated(context, intervalEntityHelper, (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)writeIntervalStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)getIntervalsStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)setIntervalLastUpdateTimeAndDateStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)updateRecoveryStateStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)setIntervalProcessedStatement))).toCompletableFuture();
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static IntervalOperator init(MapperContext context) {
        BlockingOperation.checkNotDriverThread();
        return (IntervalOperator)CompletableFutures.getUninterruptibly(IntervalOperatorImpl__MapperGenerated.initAsync(context));
    }
}

