/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.exactpro.cradle.Order;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchMetadataEntity;
import com.exactpro.cradle.messages.StoredMessage;
import com.exactpro.cradle.messages.StoredMessageBatch;
import com.exactpro.cradle.messages.StoredMessageBatchId;
import com.exactpro.cradle.messages.StoredMessageId;
import com.exactpro.cradle.utils.CompressionUtils;
import com.exactpro.cradle.utils.MessageUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class MessageBatchEntity
extends MessageBatchMetadataEntity {
    private static final Logger logger = LoggerFactory.getLogger(MessageBatchEntity.class);
    @CqlName(value="z_content")
    private ByteBuffer content;

    public MessageBatchEntity() {
    }

    public MessageBatchEntity(StoredMessageBatch batch, UUID instanceId) throws IOException {
        super(batch, instanceId);
        logger.debug("Creating Entity with meta-data");
        byte[] batchContent = MessageUtils.serializeMessages((Collection)batch.getMessages());
        boolean toCompress = this.isNeedToCompress(batchContent);
        if (toCompress) {
            StoredMessageBatchId id = batch.getId();
            try {
                logger.trace("Compressing content of message batch {}", (Object)id);
                batchContent = CompressionUtils.compressData((byte[])batchContent);
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not compress message batch contents (ID: '%s') to save in Cradle", id.toString()), e);
            }
        }
        this.setCompressed(toCompress);
        this.setContent(ByteBuffer.wrap(batchContent));
    }

    protected boolean isNeedToCompress(byte[] contentBytes) {
        return contentBytes.length > 5000;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public void setContent(ByteBuffer content) {
        this.content = content;
    }

    public Collection<StoredMessage> toStoredMessages() throws IOException {
        return this.toStoredMessages(Order.DIRECT);
    }

    public Collection<StoredMessage> toStoredMessages(Order order) throws IOException {
        List messages = MessageUtils.bytesToMessages((ByteBuffer)this.content, (boolean)this.isCompressed());
        if (order == Order.DIRECT) {
            return messages;
        }
        Collections.reverse(messages);
        return messages;
    }

    public StoredMessage toStoredMessage(StoredMessageId id) throws IOException {
        return MessageUtils.bytesToOneMessage((ByteBuffer)this.content, (boolean)this.isCompressed(), (StoredMessageId)id);
    }
}

