/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.exactpro.cradle.Direction;
import com.exactpro.cradle.messages.StoredMessageBatch;
import com.exactpro.cradle.messages.StoredMessageBatchId;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class MessageBatchMetadataEntity {
    private static final Logger logger = LoggerFactory.getLogger(MessageBatchMetadataEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="stream_name")
    private String streamName;
    @ClusteringColumn(value=0)
    @CqlName(value="direction")
    private String direction;
    @ClusteringColumn(value=1)
    @CqlName(value="message_index")
    private long messageIndex;
    @CqlName(value="compressed")
    private boolean compressed;

    public MessageBatchMetadataEntity() {
    }

    public MessageBatchMetadataEntity(StoredMessageBatch batch, UUID instanceId) {
        logger.debug("Creating meta-data from message batch");
        this.setInstanceId(instanceId);
        StoredMessageBatchId id = batch.getId();
        this.setStreamName(id.getStreamName());
        this.setDirection(id.getDirection().getLabel());
        this.setMessageIndex(id.getIndex());
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public long getMessageIndex() {
        return this.messageIndex;
    }

    public void setMessageIndex(long messageIndex) {
        this.messageIndex = messageIndex;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public StoredMessageBatchId createBatchId() {
        return new StoredMessageBatchId(this.getStreamName(), Direction.byLabel((String)this.getDirection()), this.getMessageIndex());
    }
}

