/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.exactpro.cradle.messages.StoredMessageId;
import com.exactpro.cradle.testevents.StoredTestEventId;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class MessageTestEventEntity {
    private static final Logger logger = LoggerFactory.getLogger(MessageTestEventEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="message_id")
    private String messageId;
    @ClusteringColumn(value=0)
    @CqlName(value="test_event_id")
    private String eventId;
    @CqlName(value="batch_id")
    private String batchId;

    public MessageTestEventEntity() {
    }

    public MessageTestEventEntity(StoredMessageId messageId, StoredTestEventId eventId, StoredTestEventId batchId, UUID instanceId) throws IOException {
        logger.debug("Creating entity with message-event link");
        this.messageId = messageId.toString();
        this.eventId = eventId.toString();
        if (batchId != null) {
            this.batchId = batchId.toString();
        }
        this.instanceId = instanceId;
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }
}

