/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.messages;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.DaoBase;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageEntity;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageEntityHelper__MapperGenerated;
import com.exactpro.cradle.cassandra.dao.messages.TimeMessageOperator;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMessageOperatorImpl__MapperGenerated
extends DaoBase
implements TimeMessageOperator {
    private static final Logger LOG = LoggerFactory.getLogger(TimeMessageOperatorImpl__MapperGenerated.class);
    private final TimeMessageEntityHelper__MapperGenerated timeMessageEntityHelper;
    private final PreparedStatement getNearestMessageAfterStatement;
    private final PreparedStatement getNearestMessageBeforeStatement;
    private final PreparedStatement writeMessageStatement;

    private TimeMessageOperatorImpl__MapperGenerated(MapperContext context, TimeMessageEntityHelper__MapperGenerated timeMessageEntityHelper, PreparedStatement getNearestMessageAfterStatement, PreparedStatement getNearestMessageBeforeStatement, PreparedStatement writeMessageStatement) {
        super(context);
        this.timeMessageEntityHelper = timeMessageEntityHelper;
        this.getNearestMessageAfterStatement = getNearestMessageAfterStatement;
        this.getNearestMessageBeforeStatement = getNearestMessageBeforeStatement;
        this.writeMessageStatement = writeMessageStatement;
    }

    @Override
    public CompletableFuture<TimeMessageEntity> getNearestMessageAfter(UUID instanceId, String streamName, LocalDate messageDate, String direction, LocalTime messageTime, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.getNearestMessageAfterStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (streamName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("streamName", (Object)streamName, String.class);
            }
            if (messageDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("messageDate", (Object)messageDate, LocalDate.class);
            }
            if (direction != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("direction", (Object)direction, String.class);
            }
            if (messageTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("messageTime", (Object)messageTime, LocalTime.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToSingleEntity((Statement)boundStatement, (EntityHelper)this.timeMessageEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TimeMessageEntity> getNearestMessageBefore(UUID instanceId, String streamName, LocalDate messageDate, String direction, LocalTime messageTime, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.getNearestMessageBeforeStatement.boundStatementBuilder(new Object[0]);
            NullSavingStrategy nullSavingStrategy = NullSavingStrategy.DO_NOT_SET;
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            if (instanceId != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("instanceId", (Object)instanceId, UUID.class);
            }
            if (streamName != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("streamName", (Object)streamName, String.class);
            }
            if (messageDate != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("messageDate", (Object)messageDate, LocalDate.class);
            }
            if (direction != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("direction", (Object)direction, String.class);
            }
            if (messageTime != null || nullSavingStrategy == NullSavingStrategy.SET_TO_NULL) {
                boundStatementBuilder = (BoundStatementBuilder)boundStatementBuilder.set("messageTime", (Object)messageTime, LocalTime.class);
            }
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToSingleEntity((Statement)boundStatement, (EntityHelper)this.timeMessageEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TimeMessageEntity> writeMessage(TimeMessageEntity timeMessage, Function<BoundStatementBuilder, BoundStatementBuilder> attributes) {
        try {
            BoundStatementBuilder boundStatementBuilder = this.writeMessageStatement.boundStatementBuilder(new Object[0]);
            boundStatementBuilder = attributes.apply(boundStatementBuilder);
            this.timeMessageEntityHelper.set(timeMessage, boundStatementBuilder, NullSavingStrategy.DO_NOT_SET);
            BoundStatement boundStatement = boundStatementBuilder.build();
            return this.executeAsyncAndMapToSingleEntity((Statement)boundStatement, (EntityHelper)this.timeMessageEntityHelper);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static CompletableFuture<TimeMessageOperator> initAsync(MapperContext context) {
        LOG.debug("[{}] Initializing new instance for keyspace = {} and table = {}", new Object[]{context.getSession().getName(), context.getKeyspaceId(), context.getTableId()});
        TimeMessageOperatorImpl__MapperGenerated.throwIfProtocolVersionV3((MapperContext)context);
        try {
            TimeMessageEntityHelper__MapperGenerated timeMessageEntityHelper = new TimeMessageEntityHelper__MapperGenerated(context);
            if (((Boolean)context.getCustomState().get("datastax.mapper.schemaValidationEnabled")).booleanValue()) {
                timeMessageEntityHelper.validateEntityFields();
            }
            ArrayList<CompletionStage> prepareStages = new ArrayList<CompletionStage>();
            SimpleStatement getNearestMessageAfterStatement_simple = TimeMessageOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction AND (message_date, message_time)>=(:messageDate, :messageTime) ORDER BY message_date ASC, message_time ASC, message_index ASC limit 1", (MapperContext)context, (EntityHelper)timeMessageEntityHelper);
            LOG.debug("[{}] Preparing query `{}` for method getNearestMessageAfter(java.util.UUID,java.lang.String,java.time.LocalDate,java.lang.String,java.time.LocalTime,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)getNearestMessageAfterStatement_simple.getQuery());
            CompletionStage getNearestMessageAfterStatement = TimeMessageOperatorImpl__MapperGenerated.prepare((SimpleStatement)getNearestMessageAfterStatement_simple, (MapperContext)context);
            prepareStages.add(getNearestMessageAfterStatement);
            SimpleStatement getNearestMessageBeforeStatement_simple = TimeMessageOperatorImpl__MapperGenerated.replaceKeyspaceAndTablePlaceholders((String)"SELECT * FROM ${qualifiedTableId} WHERE instance_id=:instanceId AND stream_name=:streamName AND direction=:direction AND (message_date, message_time)<=(:messageDate, :messageTime) ORDER BY message_date DESC, message_time DESC, message_index DESC limit 1", (MapperContext)context, (EntityHelper)timeMessageEntityHelper);
            LOG.debug("[{}] Preparing query `{}` for method getNearestMessageBefore(java.util.UUID,java.lang.String,java.time.LocalDate,java.lang.String,java.time.LocalTime,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)getNearestMessageBeforeStatement_simple.getQuery());
            CompletionStage getNearestMessageBeforeStatement = TimeMessageOperatorImpl__MapperGenerated.prepare((SimpleStatement)getNearestMessageBeforeStatement_simple, (MapperContext)context);
            prepareStages.add(getNearestMessageBeforeStatement);
            SimpleStatement writeMessageStatement_simple = timeMessageEntityHelper.insert().build();
            LOG.debug("[{}] Preparing query `{}` for method writeMessage(com.exactpro.cradle.cassandra.dao.messages.TimeMessageEntity,java.util.function.Function<com.datastax.oss.driver.api.core.cql.BoundStatementBuilder,com.datastax.oss.driver.api.core.cql.BoundStatementBuilder>)", (Object)context.getSession().getName(), (Object)writeMessageStatement_simple.getQuery());
            CompletionStage writeMessageStatement = TimeMessageOperatorImpl__MapperGenerated.prepare((SimpleStatement)writeMessageStatement_simple, (MapperContext)context);
            prepareStages.add(writeMessageStatement);
            return CompletableFutures.allSuccessful(prepareStages).thenApply(v -> new TimeMessageOperatorImpl__MapperGenerated(context, timeMessageEntityHelper, (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)getNearestMessageAfterStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)getNearestMessageBeforeStatement), (PreparedStatement)CompletableFutures.getCompleted((CompletionStage)writeMessageStatement))).toCompletableFuture();
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture((Throwable)t);
        }
    }

    public static TimeMessageOperator init(MapperContext context) {
        BlockingOperation.checkNotDriverThread();
        return (TimeMessageOperator)CompletableFutures.getUninterruptibly(TimeMessageOperatorImpl__MapperGenerated.initAsync(context));
    }
}

