/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.testevents.StoredTestEvent;
import java.time.LocalDate;
import java.util.UUID;

@Entity
public class ChildrenDatesEventEntity {
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="parent_id")
    private String parentId = "";
    @ClusteringColumn(value=0)
    @CqlName(value="start_date")
    private LocalDate startDate;

    public ChildrenDatesEventEntity() {
    }

    public ChildrenDatesEventEntity(StoredTestEvent event, UUID instanceId) {
        this.setInstanceId(instanceId);
        this.setParentId(event.getParentId() == null ? "" : event.getParentId().toString());
        this.setStartDate(event.getStartTimestamp().atZone(CassandraCradleStorage.TIMEZONE_OFFSET).toLocalDate());
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }
}

