/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.cassandra.dao.testevents.DateEventEntity;
import com.exactpro.cradle.testevents.StoredTestEvent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;

@Entity
public class DateTimeEventEntity
extends DateEventEntity {
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="id")
    private String id;
    @CqlName(value="start_time")
    private LocalTime startTime;

    public DateTimeEventEntity() {
    }

    public DateTimeEventEntity(StoredTestEvent event, UUID instanceId) {
        this.setInstanceId(instanceId);
        this.setId(event.getId().toString());
        this.setStartTimestamp(event.getStartTimestamp());
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    @Transient
    public Instant getStartTimestamp() {
        LocalDate sd = this.getStartDate();
        LocalTime st = this.getStartTime();
        if (sd == null || st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStartTimestamp(Instant timestamp) {
        if (timestamp == null) {
            this.setStartDate(null);
            this.setStartTime(null);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStartDate(ldt.toLocalDate());
        this.setStartTime(ldt.toLocalTime());
    }
}

