/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventEntity;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class DetailedTestEventEntity
extends TestEventEntity {
    private static final Logger logger = LoggerFactory.getLogger(DetailedTestEventEntity.class);
    @CqlName(value="stored_date")
    private LocalDate storedDate;
    @CqlName(value="stored_time")
    private LocalTime storedTime;
    @CqlName(value="event_count")
    private int eventCount;

    public DetailedTestEventEntity() {
    }

    public DetailedTestEventEntity(StoredTestEvent event, UUID instanceId) throws IOException {
        super(event, instanceId);
        logger.trace("Adding details to Entity");
        this.setStoredTimestamp(Instant.now());
        this.setEventCount(event instanceof StoredTestEventBatch ? ((StoredTestEventBatch)event).getTestEventsCount() : 1);
    }

    public LocalDate getStoredDate() {
        return this.storedDate;
    }

    public void setStoredDate(LocalDate storedDate) {
        this.storedDate = storedDate;
    }

    public LocalTime getStoredTime() {
        return this.storedTime;
    }

    public void setStoredTime(LocalTime storedTime) {
        this.storedTime = storedTime;
    }

    @Transient
    public Instant getStoredTimestamp() {
        return LocalDateTime.of(this.getStoredDate(), this.getStoredTime()).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStoredTimestamp(Instant timestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStoredDate(ldt.toLocalDate());
        this.setStoredTime(ldt.toLocalTime());
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }
}

