/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.exactpro.cradle.CradleObjectsFactory;
import com.exactpro.cradle.cassandra.dao.testevents.TestEventMetadataEntity;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventSingle;
import com.exactpro.cradle.testevents.StoredTestEventWithContent;
import com.exactpro.cradle.testevents.StoredTestEventWrapper;
import com.exactpro.cradle.testevents.TestEventBatchToStore;
import com.exactpro.cradle.testevents.TestEventBatchToStoreBuilder;
import com.exactpro.cradle.testevents.TestEventToStore;
import com.exactpro.cradle.testevents.TestEventToStoreBuilder;
import com.exactpro.cradle.utils.CompressionUtils;
import com.exactpro.cradle.utils.CradleStorageException;
import com.exactpro.cradle.utils.TestEventUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TestEventEntity
extends TestEventMetadataEntity {
    private static final Logger logger = LoggerFactory.getLogger(TestEventEntity.class);
    @CqlName(value="compressed")
    private boolean compressed;
    @CqlName(value="z_content")
    private ByteBuffer content;
    @CqlName(value="message_ids")
    private ByteBuffer messageIds;

    public TestEventEntity() {
    }

    public TestEventEntity(StoredTestEvent event, UUID instanceId) throws IOException {
        super(event, instanceId);
        byte[] content;
        logger.debug("Creating TestEventEntity from test event '{}'", (Object)event.getId());
        byte[] messageIds = null;
        if (event instanceof StoredTestEventBatch) {
            StoredTestEventBatch batch = (StoredTestEventBatch)event;
            content = TestEventUtils.serializeTestEvents((Collection)batch.getTestEvents());
            messageIds = TestEventUtils.serializeBatchLinkedMessageIds((Map)batch.getMessageIdsMap());
        } else {
            StoredTestEventSingle single = (StoredTestEventSingle)event;
            content = single.getContent();
            messageIds = TestEventUtils.serializeLinkedMessageIds((Collection)single.getMessageIds());
        }
        boolean toCompress = this.isNeedToCompress(content);
        if (toCompress) {
            try {
                logger.trace("Compressing content of test event '{}'", (Object)event.getId());
                content = CompressionUtils.compressData((byte[])content);
            }
            catch (IOException e) {
                throw new IOException(String.format("Could not compress test event contents (ID: '%s') to save in Cradle", event.getId().toString()), e);
            }
        }
        this.setCompressed(toCompress);
        this.setContent(ByteBuffer.wrap(content));
        this.setMessageIds(messageIds != null ? ByteBuffer.wrap(messageIds) : null);
    }

    protected boolean isNeedToCompress(byte[] contentBytes) {
        return contentBytes.length > 5000;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public void setContent(ByteBuffer content) {
        this.content = content;
    }

    public StoredTestEventSingle toStoredTestEventSingle(CradleObjectsFactory objectsFactory) throws IOException, CradleStorageException {
        if (this.isEventBatch()) {
            return null;
        }
        StoredTestEventId eventId = new StoredTestEventId(this.getId());
        byte[] eventContent = TestEventUtils.getTestEventContentBytes((ByteBuffer)this.content, (boolean)this.compressed, (StoredTestEventId)eventId);
        Collection ids = this.messageIds != null ? TestEventUtils.deserializeLinkedMessageIds((byte[])this.messageIds.array()) : null;
        TestEventToStore eventToStore = new TestEventToStoreBuilder().id(eventId).name(this.getName()).type(this.getType()).parentId(this.getParentId() != null ? new StoredTestEventId(this.getParentId()) : null).startTimestamp(this.getStartTimestamp()).endTimestamp(this.getEndTimestamp()).success(this.isSuccess()).content(eventContent).messageIds(ids).build();
        return objectsFactory == null ? new StoredTestEventSingle((StoredTestEventWithContent)eventToStore) : objectsFactory.createTestEvent((StoredTestEventWithContent)eventToStore);
    }

    public StoredTestEventSingle toStoredTestEventSingle() throws CradleStorageException, IOException {
        return this.toStoredTestEventSingle(null);
    }

    public StoredTestEventBatch toStoredTestEventBatch(CradleObjectsFactory objectsFactory) throws IOException, CradleStorageException {
        if (!this.isEventBatch()) {
            return null;
        }
        Map ids = this.messageIds != null ? TestEventUtils.deserializeBatchLinkedMessageIds((byte[])this.messageIds.array()) : null;
        StoredTestEventId eventId = new StoredTestEventId(this.getId());
        TestEventBatchToStore batchToStore = new TestEventBatchToStoreBuilder().id(eventId).name(this.getName()).type(this.getType()).parentId(this.getParentId() != null ? new StoredTestEventId(this.getParentId()) : null).build();
        StoredTestEventBatch storedBatch = objectsFactory == null ? new StoredTestEventBatch(batchToStore) : objectsFactory.createTestEventBatch(batchToStore);
        try {
            TestEventUtils.bytesToTestEvents((ByteBuffer)this.content, (boolean)this.compressed, (StoredTestEventBatch)storedBatch, (Map)ids);
        }
        catch (CradleStorageException e) {
            throw new IOException("Error while adding deserialized test events to batch", e);
        }
        return storedBatch;
    }

    public StoredTestEventBatch toStoredTestEventBatch() throws CradleStorageException, IOException {
        return this.toStoredTestEventBatch(null);
    }

    public StoredTestEvent toStoredTestEvent(CradleObjectsFactory objectsFactory) throws IOException, CradleStorageException {
        return this.isEventBatch() ? this.toStoredTestEventBatch(objectsFactory) : this.toStoredTestEventSingle(objectsFactory);
    }

    public StoredTestEvent toStoredTestEvent() throws IOException, CradleStorageException {
        return this.toStoredTestEvent(null);
    }

    public StoredTestEventWrapper toStoredTestEventWrapper(CradleObjectsFactory objectsFactory) throws IOException, CradleStorageException {
        return new StoredTestEventWrapper(this.toStoredTestEvent(objectsFactory));
    }

    public StoredTestEventWrapper toStoredTestEventWrapper() throws CradleStorageException, IOException {
        return this.toStoredTestEventWrapper(null);
    }

    public ByteBuffer getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(ByteBuffer messageIds) {
        this.messageIds = messageIds;
    }
}

