/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.dao.testevents;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.exactpro.cradle.cassandra.CassandraCradleStorage;
import com.exactpro.cradle.testevents.StoredTestEvent;
import com.exactpro.cradle.testevents.StoredTestEventBatch;
import com.exactpro.cradle.testevents.StoredTestEventId;
import com.exactpro.cradle.testevents.StoredTestEventMetadata;
import com.exactpro.cradle.utils.TestEventUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TestEventMetadataEntity {
    private static final Logger logger = LoggerFactory.getLogger(TestEventMetadataEntity.class);
    @PartitionKey(value=0)
    @CqlName(value="instance_id")
    private UUID instanceId;
    @PartitionKey(value=1)
    @CqlName(value="start_date")
    private LocalDate startDate;
    @ClusteringColumn(value=0)
    @CqlName(value="start_time")
    private LocalTime startTime;
    @ClusteringColumn(value=1)
    @CqlName(value="id")
    private String id;
    @CqlName(value="name")
    private String name;
    @CqlName(value="type")
    private String type;
    @CqlName(value="event_batch")
    private boolean eventBatch;
    @CqlName(value="end_date")
    private LocalDate endDate;
    @CqlName(value="end_time")
    private LocalTime endTime;
    @CqlName(value="success")
    private boolean success;
    @CqlName(value="event_count")
    private int eventCount;
    @CqlName(value="event_batch_metadata")
    private ByteBuffer eventBatchMetadata;
    @CqlName(value="root")
    private boolean root;
    @CqlName(value="parent_id")
    private String parentId;

    public TestEventMetadataEntity() {
    }

    public TestEventMetadataEntity(StoredTestEvent event, UUID instanceId) throws IOException {
        logger.debug("Creating TestEventMetadataEntity from test event '{}'", (Object)event.getId());
        StoredTestEventId parentId = event.getParentId();
        this.setInstanceId(instanceId);
        this.setId(event.getId().toString());
        this.setName(event.getName());
        this.setType(event.getType());
        this.setRoot(parentId == null);
        this.parentId = parentId != null ? parentId.toString() : "";
        this.setStartTimestamp(event.getStartTimestamp());
        this.setEndTimestamp(event.getEndTimestamp());
        this.setSuccess(event.isSuccess());
        if (event instanceof StoredTestEventBatch) {
            StoredTestEventBatch batch = (StoredTestEventBatch)event;
            this.setEventBatch(true);
            this.setEventCount(batch.getTestEventsCount());
            byte[] metadata = TestEventUtils.serializeTestEventsMetadata((Collection)batch.getTestEventsMetadata().getTestEvents());
            this.setEventBatchMetadata(ByteBuffer.wrap(metadata));
        } else {
            this.setEventBatch(false);
            this.setEventCount(1);
            this.eventBatchMetadata = null;
        }
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(UUID instanceId) {
        this.instanceId = instanceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId != null && parentId.isEmpty() ? null : parentId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public ByteBuffer getEventBatchMetadata() {
        return this.eventBatchMetadata;
    }

    public void setEventBatchMetadata(ByteBuffer eventBatchMetadata) {
        this.eventBatchMetadata = eventBatchMetadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEventBatch() {
        return this.eventBatch;
    }

    public void setEventBatch(boolean eventBatch) {
        this.eventBatch = eventBatch;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Transient
    public Instant getStartTimestamp() {
        LocalDate sd = this.getStartDate();
        LocalTime st = this.getStartTime();
        if (sd == null || st == null) {
            return null;
        }
        return LocalDateTime.of(sd, st).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setStartTimestamp(Instant timestamp) {
        if (timestamp == null) {
            this.setStartDate(null);
            this.setStartTime(null);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setStartDate(ldt.toLocalDate());
        this.setStartTime(ldt.toLocalTime());
    }

    @Transient
    public Instant getEndTimestamp() {
        LocalDate ed = this.getEndDate();
        LocalTime et = this.getEndTime();
        if (ed == null || et == null) {
            return null;
        }
        return LocalDateTime.of(ed, et).toInstant(CassandraCradleStorage.TIMEZONE_OFFSET);
    }

    @Transient
    public void setEndTimestamp(Instant timestamp) {
        if (timestamp == null) {
            this.setEndDate(null);
            this.setEndTime(null);
            return;
        }
        LocalDateTime ldt = LocalDateTime.ofInstant(timestamp, CassandraCradleStorage.TIMEZONE_OFFSET);
        this.setEndDate(ldt.toLocalDate());
        this.setEndTime(ldt.toLocalTime());
    }

    public StoredTestEventMetadata toStoredTestEventMetadata() throws IOException {
        StoredTestEventMetadata result = new StoredTestEventMetadata();
        result.setId(new StoredTestEventId(this.getId()));
        result.setName(this.name);
        result.setType(this.type);
        result.setStartTimestamp(this.getStartTimestamp());
        result.setEndTimestamp(this.getEndTimestamp());
        result.setSuccess(this.success);
        result.setBatch(this.eventBatch);
        result.setEventCount(this.eventCount);
        String parentId = this.getParentId();
        if (parentId != null) {
            result.setParentId(new StoredTestEventId(parentId));
        }
        if (this.eventBatchMetadata == null) {
            return result;
        }
        result.setBatchMetadataBytes(this.eventBatchMetadata.array());
        return result;
    }
}

