/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.iterators;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.exactpro.cradle.Order;
import com.exactpro.cradle.cassandra.dao.messages.DetailedMessageBatchEntity;
import com.exactpro.cradle.cassandra.dao.messages.converters.DetailedMessageBatchConverter;
import com.exactpro.cradle.cassandra.iterators.MessageBatchIterator;
import com.exactpro.cradle.cassandra.retries.PagingSupplies;
import com.exactpro.cradle.messages.StoredMessage;
import com.exactpro.cradle.messages.StoredMessageFilter;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesIterator
implements Iterator<StoredMessage> {
    private static final Logger logger = LoggerFactory.getLogger(MessagesIterator.class);
    private final MessageBatchIterator batchIterator;
    private final StoredMessageFilter filter;
    private Iterator<StoredMessage> messagesIterator;
    private long returnedMessages;
    private StoredMessage nextMessage;

    public MessagesIterator(StoredMessageFilter filter, MappedAsyncPagingIterable<DetailedMessageBatchEntity> rows, PagingSupplies pagingSupplies, DetailedMessageBatchConverter converter, String queryInfo) {
        this.filter = filter;
        this.batchIterator = new MessageBatchIterator(rows, filter == null ? Order.DIRECT : filter.getOrder(), pagingSupplies, converter, queryInfo);
    }

    @Override
    public boolean hasNext() {
        if (this.filter != null && this.filter.getLimit() > 0 && this.returnedMessages >= (long)this.filter.getLimit()) {
            return false;
        }
        if (this.messagesIterator == null) {
            this.messagesIterator = this.getNextMessagesIterator();
        }
        while (this.messagesIterator != null) {
            this.nextMessage = this.checkNext();
            if (this.nextMessage != null) {
                return true;
            }
            this.messagesIterator = this.getNextMessagesIterator();
        }
        return false;
    }

    private Iterator<StoredMessage> getNextMessagesIterator() {
        logger.trace("Getting messages from next batch");
        if (this.batchIterator.hasNext()) {
            return ((Collection)this.batchIterator.next()).iterator();
        }
        return null;
    }

    @Override
    public StoredMessage next() {
        if (this.nextMessage == null && !this.hasNext()) {
            return null;
        }
        StoredMessage result = this.nextMessage;
        this.nextMessage = null;
        ++this.returnedMessages;
        return result;
    }

    private StoredMessage checkNext() {
        while (this.messagesIterator.hasNext()) {
            StoredMessage msg = this.messagesIterator.next();
            if (!this.checkFilter(msg)) continue;
            return msg;
        }
        return null;
    }

    private boolean checkFilter(StoredMessage message) {
        if (this.filter == null) {
            return true;
        }
        if (this.filter.getLeftBoundIndex() > -1L && message.getIndex() < this.filter.getLeftBoundIndex()) {
            return false;
        }
        if (this.filter.getIndex() != null && !this.filter.getIndex().check((Comparable)Long.valueOf(message.getIndex()))) {
            return false;
        }
        if (this.filter.getTimestampFrom() != null && !this.filter.getTimestampFrom().check((Comparable)message.getTimestamp())) {
            return false;
        }
        return this.filter.getTimestampTo() == null || this.filter.getTimestampTo().check((Comparable)message.getTimestamp());
    }
}

