/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.retries;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.exactpro.cradle.cassandra.retries.CannotRetryException;
import com.exactpro.cradle.cassandra.retries.RetryUtils;
import com.exactpro.cradle.cassandra.retries.SelectExecutionPolicy;
import com.exactpro.cradle.cassandra.retries.SelectExecutionVerdict;
import java.util.Collection;

public class FixedNumberRetryPolicy
implements SelectExecutionPolicy {
    private int maxRetry;

    public FixedNumberRetryPolicy(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    @Override
    public SelectExecutionVerdict onError(Statement<?> statement, String queryInfo, Throwable cause, int retryCount) throws CannotRetryException {
        return this.passVerdict(cause, retryCount, statement.getPageSize());
    }

    @Override
    public SelectExecutionVerdict onError(Collection<String> ids, String queryInfo, Throwable cause, int retryCount) throws CannotRetryException {
        return this.passVerdict(cause, retryCount, ids.size());
    }

    @Override
    public SelectExecutionVerdict onNextPage(Statement<?> statement, String queryInfo) {
        return new SelectExecutionVerdict(null, statement.getPageSize());
    }

    private SelectExecutionVerdict passVerdict(Throwable cause, int retryCount, int pageSize) throws CannotRetryException {
        if (!RetryUtils.isRetriableException(cause)) {
            throw new CannotRetryException("Cannot retry after this error", cause);
        }
        if (retryCount > this.maxRetry) {
            throw new CannotRetryException("The maximum number '" + this.maxRetry + "' of retries has been reached", cause);
        }
        return new SelectExecutionVerdict(null, pageSize);
    }
}

