/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.retries;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.exactpro.cradle.cassandra.retries.CannotRetryException;
import com.exactpro.cradle.cassandra.retries.RetryUtils;
import com.exactpro.cradle.cassandra.retries.SelectExecutionPolicy;
import com.exactpro.cradle.cassandra.retries.SelectExecutionVerdict;
import java.util.Collection;

public class PageSizeAdjustingPolicy
implements SelectExecutionPolicy {
    private final int maxPageSize;
    private final int factor;

    public PageSizeAdjustingPolicy(int maxPageSize, int factor) {
        this.maxPageSize = maxPageSize;
        this.factor = factor;
        if (maxPageSize < 1) {
            throw new IllegalArgumentException("Maximum page size cannot be less than 1");
        }
        if (factor < 1) {
            throw new IllegalArgumentException("Factor cannot be less than 1");
        }
    }

    @Override
    public SelectExecutionVerdict onError(Statement<?> statement, String queryInfo, Throwable cause, int retryCount) throws CannotRetryException {
        if (!RetryUtils.isRetriableException(cause)) {
            throw new CannotRetryException("Cannot retry after this error", cause);
        }
        int pageSize = statement.getPageSize();
        if (pageSize <= this.factor) {
            throw new CannotRetryException("Page size is already too small (" + pageSize + "), cannot adjust it by dividing by " + this.factor, cause);
        }
        return new SelectExecutionVerdict(null, pageSize / this.factor);
    }

    @Override
    public SelectExecutionVerdict onError(Collection<String> ids, String queryInfo, Throwable cause, int retryCount) throws CannotRetryException {
        if (!RetryUtils.isRetriableException(cause)) {
            throw new CannotRetryException("Cannot retry after this error", cause);
        }
        int divider = (retryCount + 1) * this.factor;
        if (ids.size() <= divider) {
            throw new CannotRetryException("List size is already too small (" + ids.size() + "), cannot adjust it by dividing by " + divider, cause);
        }
        return new SelectExecutionVerdict(null, ids.size() / divider);
    }

    @Override
    public SelectExecutionVerdict onNextPage(Statement<?> statement, String queryInfo) {
        int pageSize = statement.getPageSize();
        if (pageSize < this.maxPageSize && (pageSize *= this.factor) > this.maxPageSize) {
            pageSize = this.maxPageSize;
        }
        return new SelectExecutionVerdict(null, pageSize);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getFactor() {
        return this.factor;
    }
}

