/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.retries;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.AsyncPagingIterableWrapper;
import com.exactpro.cradle.cassandra.CassandraSemaphore;
import com.exactpro.cradle.cassandra.dao.AsyncOperator;
import com.exactpro.cradle.cassandra.dao.EntityConverter;
import com.exactpro.cradle.cassandra.retries.CannotRetryException;
import com.exactpro.cradle.cassandra.retries.RetryUtils;
import com.exactpro.cradle.cassandra.retries.SelectExecutionPolicy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SelectQueryExecutor.class);
    private final CqlSession session;
    private final CassandraSemaphore semaphore;
    private final SelectExecutionPolicy multiRowResultExecPolicy;
    private final SelectExecutionPolicy singleRowResultExecPolicy;

    public SelectQueryExecutor(CqlSession session, CassandraSemaphore semaphore, SelectExecutionPolicy multiRowResultExecPolicy, SelectExecutionPolicy singleRowResultExecPolicy) {
        this.session = session;
        this.semaphore = semaphore;
        this.multiRowResultExecPolicy = multiRowResultExecPolicy;
        this.singleRowResultExecPolicy = singleRowResultExecPolicy;
    }

    public <T> CompletableFuture<T> executeSingleRowResultQuery(Supplier<CompletableFuture<T>> query, EntityConverter<T> converter, String queryInfo) {
        return new AsyncOperator(this.semaphore).getFuture(() -> {
            CompletableFuture f = new CompletableFuture();
            ((CompletableFuture)query.get()).whenCompleteAsync((result, error) -> this.onCompleteSingle((Object)result, (Throwable)error, f, converter::convert, queryInfo, 0));
            return f;
        });
    }

    public <T> CompletableFuture<MappedAsyncPagingIterable<T>> executeMultiRowResultQuery(Supplier<CompletableFuture<MappedAsyncPagingIterable<T>>> query, EntityConverter<T> converter, String queryInfo) {
        return new AsyncOperator(this.semaphore).getFuture(() -> {
            CompletableFuture f = new CompletableFuture();
            Function<Row, Object> mapper = converter::convert;
            ((CompletableFuture)query.get()).whenCompleteAsync((result, error) -> this.onCompleteMulti((MappedAsyncPagingIterable)result, (Throwable)error, f, (Function)mapper, queryInfo, 0));
            return f;
        });
    }

    private Statement<?> handleErrorAndGetStatement(Throwable error, CompletableFuture<?> f, SelectExecutionPolicy execPolicy, String queryInfo, int retryCount) {
        DriverException driverError = RetryUtils.getDriverException(error);
        if (driverError == null) {
            logger.error("Cannot retry '" + queryInfo + "' after non-driver exception", error);
            f.completeExceptionally(error);
            return null;
        }
        Statement stmt = driverError.getExecutionInfo().getStatement();
        try {
            return RetryUtils.applyPolicyVerdict(stmt, execPolicy.onError(stmt, queryInfo, error, retryCount));
        }
        catch (CannotRetryException e) {
            f.completeExceptionally(e);
            return null;
        }
    }

    private <T> void onCompleteSingle(T result, Throwable error, CompletableFuture<T> f, Function<Row, T> mapper, String queryInfo, int retryCount) {
        if (error == null) {
            f.complete(result);
            return;
        }
        Statement<?> stmt = this.handleErrorAndGetStatement(error, f, this.singleRowResultExecPolicy, queryInfo, retryCount);
        if (f.isDone()) {
            return;
        }
        try {
            long delay = RetryUtils.calculateDelayWithJitter(retryCount);
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> logger.debug("Retrying request ({}) '{}' and CL {} with delay {}ms after error: '{}'", new Object[]{retryCount + 1, queryInfo, stmt.getConsistencyLevel(), delay, error.getMessage()}), CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS)).thenComposeAsync(r -> this.session.executeAsync(stmt))).thenApplyAsync(AsyncPagingIterable::one)).thenApplyAsync(row -> row == null ? null : mapper.apply((Row)row))).whenCompleteAsync((retryResult, retryError) -> this.onCompleteSingle((Object)retryResult, (Throwable)retryError, f, mapper, queryInfo, retryCount + 1));
        }
        catch (Exception e) {
            logger.error("Error while retrying '" + queryInfo + "'", (Throwable)e);
            f.completeExceptionally(e);
        }
    }

    private <T> void onCompleteMulti(MappedAsyncPagingIterable<T> result, Throwable error, CompletableFuture<MappedAsyncPagingIterable<T>> f, Function<Row, T> mapper, String queryInfo, int retryCount) {
        if (error == null) {
            f.complete(result);
            return;
        }
        Statement<?> stmt = this.handleErrorAndGetStatement(error, f, this.multiRowResultExecPolicy, queryInfo, retryCount);
        if (f.isDone()) {
            return;
        }
        try {
            long delay = RetryUtils.calculateDelayWithJitter(retryCount);
            ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> logger.debug("Retrying request ({}) '{}' and CL {} with delay {}ms after error: '{}'", new Object[]{retryCount + 1, queryInfo, stmt.getConsistencyLevel(), delay, error.getMessage()}), CompletableFuture.delayedExecutor(delay, TimeUnit.MILLISECONDS)).thenComposeAsync(r -> this.session.executeAsync(stmt))).thenApplyAsync(row -> new AsyncPagingIterableWrapper((AsyncPagingIterable)row, mapper))).whenCompleteAsync((retryResult, retryError) -> this.onCompleteMulti((MappedAsyncPagingIterable)retryResult, (Throwable)retryError, f, mapper, queryInfo, retryCount + 1));
        }
        catch (Exception e) {
            logger.error("Error while retrying '" + queryInfo + "'", (Throwable)e);
            f.completeExceptionally(e);
        }
    }
}

