/*
 * Decompiled with CFR 0.152.
 */
package com.exactpro.cradle.cassandra.utils;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.exactpro.cradle.cassandra.dao.messages.DetailedMessageBatchEntity;
import com.exactpro.cradle.cassandra.dao.messages.MessageBatchOperator;
import com.exactpro.cradle.filters.ComparisonOperation;
import com.exactpro.cradle.messages.StoredMessage;
import com.exactpro.cradle.messages.StoredMessageFilter;
import com.exactpro.cradle.messages.StoredMessageId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class CassandraMessageUtils {
    public static Select prepareSelect(String keyspace, String tableName, UUID instanceId) {
        return (Select)QueryBuilder.selectFrom((String)keyspace, (String)tableName).all().whereColumn("instance_id").isEqualTo((Term)QueryBuilder.literal((Object)instanceId));
    }

    public static CompletableFuture<DetailedMessageBatchEntity> getMessageBatch(StoredMessageId id, MessageBatchOperator op, UUID instanceId, Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs) {
        return op.getMessageBatch(instanceId, id.getStreamName(), id.getDirection().getLabel(), id.getIndex(), readAttrs).thenApply(batch -> {
            if (batch == null || batch.getLastMessageIndex() >= id.getIndex()) {
                return batch;
            }
            return null;
        });
    }

    public static long findLeftMessageIndex(DetailedMessageBatchEntity batch, StoredMessageFilter filter, UUID instanceId, MessageBatchOperator op, Function<BoundStatementBuilder, BoundStatementBuilder> readAttrs) throws IOException {
        ArrayList<StoredMessage> batchMessages = new ArrayList<StoredMessage>(batch.toStoredMessages());
        int count = filter.getLimit();
        boolean inclusive = filter.getIndex().getOperation() == ComparisonOperation.LESS_OR_EQUALS;
        long index = (Long)filter.getIndex().getValue();
        boolean found = false;
        ListIterator batchMessagesIt = batchMessages.listIterator(batchMessages.size());
        while (batchMessagesIt.hasPrevious()) {
            StoredMessage m = (StoredMessage)batchMessagesIt.previous();
            if (!found) {
                if (m.getIndex() != index) continue;
                if (inclusive) {
                    --count;
                }
                found = true;
                continue;
            }
            if (--count > 0) continue;
            filter.setLeftBoundIndex(m.getIndex());
            return batch.getMessageIndex();
        }
        PagingIterable<DetailedMessageBatchEntity> otherBatches = op.getMessageBatchesReversed(instanceId, batch.getStreamName(), batch.getDirection(), batch.getMessageIndex() - 1L, readAttrs);
        if (otherBatches == null) {
            return -1L;
        }
        for (DetailedMessageBatchEntity ob : otherBatches) {
            if (ob.getMessageCount() <= count) {
                if ((count -= ob.getMessageCount()) > 0) continue;
                return ob.getMessageIndex();
            }
            ArrayList<StoredMessage> obMessages = new ArrayList<StoredMessage>(ob.toStoredMessages());
            ListIterator listIt = obMessages.listIterator(obMessages.size());
            while (listIt.hasPrevious()) {
                StoredMessage m = (StoredMessage)listIt.previous();
                if (--count > 0) continue;
                filter.setLeftBoundIndex(m.getIndex());
                return ob.getMessageIndex();
            }
        }
        return -1L;
    }
}

